/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.reflection.XReflection;

public class TurretTypeArrow
extends TurretTypeRanged {
    private static final boolean ADVANCED_ARROWS = XReflection.supports((int)14);

    public TurretTypeArrow() {
        super("arrow", true, false);
    }

    @Override
    public boolean tryActivate(TurretActivateEvent event) {
        boolean instantDamage;
        TurretTypeRanged.ShootingCalculations calc = (TurretTypeRanged.ShootingCalculations)event.getExtra();
        Location from = calc.from;
        RangedTurret turret = (RangedTurret)event.getTurret();
        XEntityType type = turret.getProjectile();
        LivingEntity target = event.getTarget();
        Kingdom kingdom = event.getKingdom();
        boolean bl = instantDamage = type == null;
        if (type != null) {
            turret.shootEntity(type, kingdom, from, calc.direction);
            if (calc.distance <= 3.0) {
                instantDamage = true;
            }
        } else {
            turret.activate(target, kingdom);
            ParticleDisplay particle = turret.getParticle();
            if (particle != null) {
                Particles.line((Location)from, (Location)target.getEyeLocation(), (double)0.1, (ParticleDisplay)particle);
            }
            if (turret.canSetOnFire(kingdom)) {
                target.setFireTicks(100);
            }
        }
        if (instantDamage) {
            double damage = turret.getDamage(kingdom);
            if (damage > 0.0) {
                target.damage(damage);
            }
            turret.activate(target, kingdom);
        }
        return true;
    }
}

