/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.building.info.BuildingFunctionalPoint;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.effects.SlownessTurretEffect;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.string.Strings;

public class RangedTurret
extends Turret
implements PlayerOperator {
    private Player operator;
    private boolean manual = KingdomsConfig.Turrets.MANUAL_BY_DEFAULT.getManager().getBoolean();
    private transient int cooldown;
    private int ammo;
    private Location activationPoint;
    private static final boolean ADVANCED_ARROWS = XReflection.supports((int)14);
    public static final String ORIGIN_METADATA = "TURRET_ORIGIN";
    public static final String ORIGIN_KINGDOM = "TURRET_KINGDOM";

    public RangedTurret(TurretStyle type, SimpleLocation location) {
        super(type, location);
    }

    public int getAmmo() {
        return this.ammo;
    }

    public void setAmmo(int ammo) {
        this.ammo = ammo;
    }

    public void postActivation(Kingdom kingdom) {
        if (((TurretStyle)this.style).needsAmmo()) {
            --this.ammo;
        }
        Optional slowness = this.getEffect(SlownessTurretEffect.NS);
        this.cooldown = this.getCooldown(kingdom, this.level);
        if (slowness.isPresent()) {
            MathExpression delay = ((SlownessTurretEffect)slowness.get()).getDelayedTicks();
            this.cooldown += (int)MathUtils.eval(delay, (PlaceholderProvider)new PlaceholderContextBuilder().raw("cooldown", this.cooldown));
        }
    }

    public Location getActivationPoint() {
        if (this.activationPoint != null) {
            return this.activationPoint;
        }
        Map<BlockVector3, List<BuildingFunctionalPoint>> fnPoints = this.building.getSettings().getFunctionalPoints();
        BlockVector3 activePoint = fnPoints.entrySet().stream().filter(x -> ((List)x.getValue()).stream().anyMatch(y -> y.getType().equals("activation"))).map(Map.Entry::getKey).findAny().orElseThrow(() -> new IllegalStateException("Cannot find activation point for turret " + ((TurretStyle)this.style).getName() + " | " + Strings.associatedArrayMap(fnPoints) + "   " + this.level));
        this.activationPoint = new Location(this.origin.getBukkitWorld(), (double)activePoint.getX(), (double)activePoint.getY(), (double)activePoint.getZ());
        return this.activationPoint;
    }

    public boolean isOutOfAmmo() {
        return ((TurretStyle)this.style).needsAmmo() && this.ammo <= 0;
    }

    public int addAmmo(int amount) {
        return this.ammo += amount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + this.cooldown;
        result = prime * result + this.ammo;
        return result;
    }

    public XEntityType getProjectile() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("projectile").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        String projectile = section.getString(String.valueOf(entry));
        Optional type = XEntityType.of((String)projectile);
        return type.map(xEntityType -> (XEntityType)xEntityType.or((XBase)XEntityType.ARROW)).orElse(null);
    }

    public double getSpeed(Kingdom kingdom) {
        return this.getSpeed(kingdom, this.level);
    }

    public double getSpeed(Kingdom kingdom, int lvl) {
        return this.eval("speed", kingdom, lvl);
    }

    @Override
    public boolean canFunction() {
        return super.canFunction() && this.cooldown <= 0 && !this.isOutOfAmmo();
    }

    public int passThroughLevel(Kingdom kingdom) {
        return (int)this.eval("pass-through", kingdom, this.level);
    }

    public boolean canPassThrough(Kingdom kingdom) {
        int passThroLevel = this.passThroughLevel(kingdom);
        return passThroLevel != 0 && this.level >= passThroLevel;
    }

    @Override
    public boolean skipTarget(LivingEntity target) {
        return this.isOutOfAmmo() || super.skipTarget(target);
    }

    public void setOperator(Player operator) {
        this.operator = operator;
    }

    public Player getOperator() {
        return this.operator;
    }

    @Override
    @MustBeInvokedByOverriders
    public MessagePlaceholderProvider addMessageContextEdits(MessagePlaceholderProvider context, Kingdom kingdom) {
        return ((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)((MessagePlaceholderProvider)super.addMessageContextEdits(context, kingdom).raw("ammo", this.ammo).raw("manual", this.manual).raw("speed", () -> this.getSpeed(kingdom))).raw("next_speed", () -> this.getSpeed(kingdom, this.level + 1))).raw("range", () -> this.getRange(kingdom))).raw("next_range", () -> this.getRange(kingdom, this.level + 1))).raw("max_targets", () -> this.getMaxTargets(kingdom))).raw("next_max_targets", () -> this.getMaxTargets(kingdom, this.level + 1))).raw("max_ammo", () -> this.getMaxAmmo(kingdom))).raw("next_max_ammo", () -> this.getMaxAmmo(kingdom, this.level + 1))).raw("cooldown", () -> this.getCooldown(kingdom))).raw("next_cooldown", () -> this.getCooldown(kingdom, this.level + 1))).raw("knockback", () -> this.getKnockback(kingdom))).raw("next_knockback", () -> this.getKnockback(kingdom, this.level + 1));
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        if (this.operator != null) {
            ChairManager.standUp(this.operator);
        }
        return super.remove(context);
    }

    public double getRange(Kingdom kingdom, int lvl) {
        return this.eval("range", kingdom, lvl);
    }

    public double getRange(Kingdom kingdom) {
        return this.getRange(kingdom, this.level);
    }

    public int getCooldown(Kingdom kingdom, int lvl) {
        return (int)this.eval("cooldown", kingdom, lvl);
    }

    public int getCooldown(Kingdom kingdom) {
        return this.getCooldown(kingdom, this.level);
    }

    public int getAmmoCost(Kingdom kingdom) {
        return (int)this.eval("ammo", kingdom, this.level);
    }

    public int getMaxAmmo(Kingdom kingdom) {
        return this.getMaxAmmo(kingdom, this.level);
    }

    public int getMaxAmmo(Kingdom kingdom, int lvl) {
        return (int)this.eval("max-ammo", kingdom, lvl);
    }

    public int getMaxTargets(Kingdom kingdom, int lvl) {
        return (int)this.eval("max-targets", kingdom, lvl);
    }

    public int getMaxTargets(Kingdom kingdom) {
        return this.getMaxTargets(kingdom, this.level);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void tick() {
        --this.cooldown;
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        if (((TurretStyle)this.style).needsAmmo()) {
            context.getDataProvider().setInt("ammo", this.ammo);
        }
        if (this.manual) {
            context.getDataProvider().setBoolean("manual", this.manual);
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        if (((TurretStyle)this.style).needsAmmo()) {
            this.ammo = context.getDataProvider().getInt("ammo");
        }
        this.manual = context.getDataProvider().getBoolean("manual");
    }

    public Entity shootEntity(XEntityType type, Kingdom kingdom, Location from, Vector direction) {
        Arrow projectile;
        double speed = this.getSpeed(kingdom);
        World world = this.origin.getBukkitWorld();
        if (type == XEntityType.ARROW || type == XEntityType.SPECTRAL_ARROW) {
            if (ADVANCED_ARROWS) {
                Class classType = type == XEntityType.SPECTRAL_ARROW ? SpectralArrow.class : Arrow.class;
                projectile = world.spawnArrow(from, direction, (float)speed, 3.0f, classType);
            } else {
                projectile = world.spawnArrow(from, direction, (float)speed, 3.0f);
            }
        } else {
            projectile = world.spawnEntity(from, ((XEntityType)type.or((XBase)XEntityType.SNOWBALL)).get());
            projectile.setVelocity(projectile.getVelocity().multiply(speed));
        }
        if (this.canSetOnFire(kingdom)) {
            projectile.setFireTicks(1200);
        }
        this.repeatedParticle(this, (Entity)projectile);
        RangedTurret.setMetadata((Entity)projectile, this, kingdom);
        return projectile;
    }

    protected static void setMetadata(Entity entity2, RangedTurret turret, Kingdom kingdom) {
        entity2.setMetadata(ORIGIN_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)turret));
        entity2.setMetadata(ORIGIN_KINGDOM, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)kingdom));
    }

    public void repeatedParticle(Turret turret, final Entity entity2) {
        final ParticleDisplay display = turret.getParticle();
        if (display == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!entity2.isValid()) {
                    this.cancel();
                    return;
                }
                display.spawn(entity2.getLocation());
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L);
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.operator);
    }
}

