/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.effects;

import java.time.Duration;
import org.kingdoms.constants.land.turrets.effects.PersistentTurretEffect;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/constants/land/turrets/effects/AbstractPersistentTurretEffect;", "Lorg/kingdoms/constants/land/turrets/effects/PersistentTurretEffect;", "ns", "Lorg/kingdoms/constants/namespace/Namespace;", "duration", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/constants/namespace/Namespace;Ljava/time/Duration;)V", "getDuration", "()Ljava/time/Duration;", "getNamespace", "started", "", "getStarted", "()J", "hasExpired", "", "getHasExpired", "()Z", "core"})
public abstract class AbstractPersistentTurretEffect
implements PersistentTurretEffect {
    @NotNull
    private final Namespace ns;
    @NotNull
    private final Duration duration;
    private final long started;

    public AbstractPersistentTurretEffect(@NotNull Namespace ns, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.ns = ns;
        this.duration = duration;
        this.started = System.currentTimeMillis();
    }

    @Override
    @NotNull
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public Namespace getNamespace() {
        return this.ns;
    }

    @Override
    public long getStarted() {
        return this.started;
    }

    public boolean getHasExpired() {
        long current = System.currentTimeMillis();
        long passed = current - this.getStarted();
        return passed >= this.getDuration().toMillis();
    }
}

