/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import com.google.common.base.Strings;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.Chair;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigSection;

public abstract class TurretType
extends KingdomBuildingType<Turret, TurretStyle, TurretType> {
    public static final String METADATA = "Turret";
    private final boolean enemies;
    private final boolean friends;

    public TurretType(String name, boolean enemies, boolean friends) {
        super(name);
        this.enemies = enemies;
        this.friends = friends;
    }

    public static void call(TurretActivateEvent event) {
        Bukkit.getPluginManager().callEvent((Event)event);
        event.getTurret().setLastActivation(event);
    }

    @Override
    public final String getCategoryName() {
        return "Turrets";
    }

    public boolean isRanged() {
        return this instanceof TurretTypeRanged;
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Turret> context) {
        KingdomItemInteractEvent<Turret> event = context.getEvent();
        Kingdom viewerKingdom = event.getPlayer().getKingdom();
        KingdomPlayer viewerKp = event.getPlayer();
        Player viewer = viewerKp.getPlayer();
        boolean isViewerAdmin = KingdomsDefaultPluginPermission.TURRETS_INTERACT.hasPermission((CommandSender)viewer, true);
        Turret turret = (Turret)event.getKingdomBlock();
        Kingdom turretKingdom = turret.getLand().getKingdom();
        InteractiveGUI gui = GUIAccessor.prepare(viewer, "turrets/" + ((TurretStyle)turret.getStyle()).getName(), true, turret.getMessageContext());
        if (gui == null) {
            return null;
        }
        gui.getMessageContext().withContext(turretKingdom);
        gui.push("upgrade", () -> {
            KingdomsBlockUpgradeContext<Turret> upgradeContext = new KingdomsBlockUpgradeContext<Turret>(viewerKp, turret, turret.getLevel() + 1);
            Messenger error = turret.getKingdomBlockHandler().onUpgrade(upgradeContext);
            if (error == null) {
                upgradeContext.finalizeProcess();
            } else {
                error.sendError((CommandSender)viewer, upgradeContext.getMessageContext());
            }
        }, new Object[0]);
        if (turret instanceof RangedTurret) {
            RangedTurret ammoTurret = (RangedTurret)turret;
            int maxAmmo = ammoTurret.getMaxAmmo(turretKingdom);
            gui.option("manual").on(ClickType.LEFT, () -> {
                ammoTurret.setManual(!ammoTurret.isManual());
                this.open(context);
                context.closeForOthers();
            }).on(ClickType.RIGHT, () -> {
                if (!ammoTurret.isManual()) {
                    KingdomsLang.TURRETS_NOT_MANUAL.sendError((CommandSender)viewer, new Object[0]);
                    return;
                }
                ammoTurret.setOperator(viewer);
                Entity chair = Chair.sitOnChair(viewer, ammoTurret.getOrigin().toBukkitLocation().add(0.0, 0.5, 0.0));
                ChairManager.sit(viewer, new ChairSession<Object>(chair, () -> ammoTurret.setOperator(null), ammoTurret));
                KingdomsLang.TURRETS_MANUAL_OPERATING.sendMessage((CommandSender)viewer);
            }).done();
            ConfigSection options = gui.getOptionsSection().getSection("ammo");
            int cost = options.getInt("cost");
            String fillCostStr = options.getString("fill-cost");
            if (Strings.isNullOrEmpty((String)fillCostStr)) {
                fillCostStr = "neededAmmo / 8";
            }
            int fillCost = (int)MathUtils.eval(fillCostStr, turretKingdom, "neededAmmo", maxAmmo - ammoTurret.getAmmo());
            int buyAmmoAmount = options.getInt("ammo");
            Runnable normalPurchase = () -> {
                if (!isViewerAdmin && !viewerKingdom.getResourcePoints().has(cost)) {
                    KingdomsLang.TURRET_AMMO_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)viewer);
                    return;
                }
                if (ammoTurret.getAmmo() + buyAmmoAmount > maxAmmo) {
                    KingdomsLang.TURRET_AMMO_MAX_AMMO.sendError((CommandSender)viewer, new Object[0]);
                    return;
                }
                TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, buyAmmoAmount, cost, TurretAmmoFillEvent.FillType.NORMAL_PURCHASE, viewerKp);
                Bukkit.getPluginManager().callEvent((Event)ammoEvent);
                if (ammoEvent.isCancelled()) {
                    return;
                }
                if (!isViewerAdmin) {
                    viewerKingdom.getResourcePoints().add(-cost);
                }
                ammoTurret.addAmmo(ammoEvent.getAmount());
                this.open(context);
                KingdomsLang.TURRET_AMMO_PURCHASED.sendMessage((CommandSender)viewer);
                context.closeForOthers();
            };
            Runnable bulkPurchase = () -> {
                int updatedFillCost = (int)MathUtils.eval(options.getString("fill-cost"), turretKingdom, "neededAmmo", maxAmmo - ammoTurret.getAmmo());
                int left = maxAmmo - ammoTurret.getAmmo();
                if (!isViewerAdmin && !viewerKingdom.getResourcePoints().has(updatedFillCost)) {
                    KingdomsLang.TURRET_AMMO_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)viewer);
                    return;
                }
                TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, left, updatedFillCost, TurretAmmoFillEvent.FillType.BULK_PURCHASE, viewerKp);
                Bukkit.getPluginManager().callEvent((Event)ammoEvent);
                if (ammoEvent.isCancelled()) {
                    return;
                }
                if (!isViewerAdmin) {
                    viewerKingdom.getResourcePoints().add(-updatedFillCost);
                }
                ammoTurret.addAmmo(ammoEvent.getAmount());
                this.open(context);
                KingdomsLang.TURRET_AMMO_PURCHASED.sendMessage((CommandSender)viewer);
                context.closeForOthers();
            };
            gui.option("ammo").setEdits("ammo-buy-amount", buyAmmoAmount, "cost", cost, "fill-cost", fillCost).on(ClickType.LEFT, normalPurchase).on(ClickType.SHIFT_LEFT, fillCost <= 0 ? normalPurchase : bulkPurchase).done();
        }
        context.finalizeGUI(gui);
        return gui;
    }

    public boolean tryActivate(TurretActivateEvent event) {
        event.getTurret().activate(event.getTarget(), event.getKingdom());
        return true;
    }

    public boolean isFriends() {
        return this.friends;
    }

    public boolean isEnemies() {
        return this.enemies;
    }

    @Override
    public Turret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new Turret(builder.getStyle(), builder.getLocation());
    }
}

