/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.effects.ParalysisTurretEffect;
import org.kingdoms.constants.land.turrets.effects.PersistentTurretEffect;
import org.kingdoms.constants.land.turrets.effects.TurretEffect;
import org.kingdoms.constants.land.turrets.objects.MineTurret;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.events.items.KingdomItemPlaceContext;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.managers.buildings.turrets.TurretLandCacheOptimizationWatcher;
import org.kingdoms.managers.buildings.turrets.TurretManager;
import org.kingdoms.managers.buildings.turrets.TurretStateCache;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.single.TickedCache;
import org.kingdoms.utils.internal.functional.Fn;

public class Turret
extends KingdomBuilding<TurretStyle> {
    private transient TurretActivateEvent lastActivation;
    private TickedCache<TurretStateCache> stateCache;
    private final transient NamespacedMap<PersistentTurretEffect> effects = new NamespacedMap(new ConcurrentHashMap());

    public Turret(@NonNull TurretStyle style, @NonNull SimpleLocation location) {
        super(style, location);
    }

    public void invalidateStateCache() {
        if (this.stateCache != null) {
            this.stateCache.invalidate();
        }
    }

    public TickedCache<TurretStateCache> getStateCache() {
        if (this.stateCache == null) {
            this.stateCache = new TickedCache((int)TurretFactory.ACCURACY);
        }
        return this.stateCache;
    }

    public boolean skipTarget(LivingEntity target) {
        return !this.canTargetEntityType(target.getType());
    }

    public boolean canSetOnFire(Kingdom kingdom) {
        return this.setOnFireLevel(kingdom) <= this.level;
    }

    public boolean canDetectInvisible(Kingdom kingdom) {
        return this.level >= this.invisibilityDetectionLevel(kingdom);
    }

    @Override
    protected Map<BlockVector3, KingdomBlock> getDataMap(Land land) {
        return (Map)Fn.cast(land.unsafeGetTurrets());
    }

    public boolean canTargetEntityType(EntityType entityType) {
        return ((TurretStyle)this.style).getAllowedEntityTypes().contains(entityType);
    }

    private void cleanupExpiredEffects() {
        this.effects.values().removeIf(PersistentTurretEffect::hasExpired);
    }

    public @Unmodifiable Map<Namespace, PersistentTurretEffect> getEffects() {
        this.cleanupExpiredEffects();
        return Collections.unmodifiableMap(this.effects);
    }

    public void addEffect(TurretEffect effect) {
        if (!(effect instanceof PersistentTurretEffect)) {
            effect.apply(this);
            return;
        }
        this.effects.put(effect.getNamespace(), (PersistentTurretEffect)effect);
    }

    public <T extends PersistentTurretEffect> Optional<T> getEffect(Namespace name) {
        PersistentTurretEffect effect = this.effects.get(name);
        if (effect == null) {
            return Optional.empty();
        }
        if (effect.hasExpired()) {
            this.effects.remove(name);
            return Optional.empty();
        }
        return Optional.of(effect);
    }

    public @NonNull List<PotionEffect> getHitEffects() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("effects").getSection();
        if (section == null) {
            return new ArrayList<PotionEffect>();
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        List<String> effects = section.getStringList(String.valueOf(entry));
        return XPotion.parseEffects(effects).stream().filter(XPotion.Effect::hasChance).map(XPotion.Effect::getEffect).collect(Collectors.toList());
    }

    public @Nullable ParticleDisplay getParticle() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("particle").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor display = section.gotoSection(String.valueOf(entry));
        if (display == null) {
            return null;
        }
        return ParticleDisplay.fromConfig((ConfigurationSection)display.toBukkitConfigurationSection());
    }

    @Override
    public KingdomItemPlaceEvent<Turret> place(KingdomItemPlaceContext context) {
        KingdomItemPlaceEvent<Turret> event = super.place(context);
        if (context.getAddData()) {
            this.modifyData(this.getLand(), true);
        }
        return event;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onBuildFinish() {
        super.onBuildFinish();
        TurretLandCacheOptimizationWatcher.checked(this.getLand(), null);
    }

    public void applyKnockback(LivingEntity target, Kingdom kingdom) {
        LocationUtils.knockback(this.origin.toVector(), (Entity)target, this.getKnockback(kingdom), this.getVerticalKnockback(kingdom, this.level));
    }

    public double getKnockback(Kingdom kingdom) {
        return this.getKnockback(kingdom, this.level);
    }

    public double getKnockback(Kingdom kingdom, int lvl) {
        return this.eval("knockback", kingdom, lvl);
    }

    public double getVerticalKnockback(Kingdom kingdom, int lvl) {
        return this.eval("vertical-knockback", kingdom, lvl);
    }

    @Override
    @MustBeInvokedByOverriders
    public MessagePlaceholderProvider addMessageContextEdits(MessagePlaceholderProvider context, Kingdom kingdom) {
        return ((MessagePlaceholderProvider)super.addMessageContextEdits(context, kingdom).raw("damage", () -> this.getDamage(kingdom))).raw("next_damage", () -> this.getDamage(kingdom, this.level + 1));
    }

    public double getDamage(@NonNull Kingdom kingdom) {
        return this.getDamage(kingdom, this.level);
    }

    public double getDamage(@NonNull Kingdom kingdom, int lvl) {
        return this.eval("damage", kingdom, lvl);
    }

    public int setOnFireLevel(@NonNull Kingdom kingdom) {
        return (int)this.eval("fire", kingdom, this.level);
    }

    public int invisibilityDetectionLevel(@NonNull Kingdom kingdom) {
        return (int)this.eval("invisibility-detection", kingdom, this.level);
    }

    public int getArmorDamage(@NonNull Kingdom kingdom, int lvl) {
        return (int)this.eval("armor-damage", kingdom, lvl);
    }

    public int getArmorDamage(@NonNull Kingdom kingdom) {
        return this.getArmorDamage(kingdom, this.level);
    }

    public void damage(@NonNull TurretActivateEvent event) {
        event.getTarget().damage(this.getDamage(event.getKingdom()));
    }

    public List<String> getDeathMessages() {
        return ((TurretStyle)this.style).getOption("death-messages").getStringList();
    }

    @Override
    public boolean canFunction() {
        if (!super.canFunction()) {
            return false;
        }
        Optional paralysis = this.getEffect(ParalysisTurretEffect.NS);
        return !paralysis.isPresent();
    }

    public @Nullable String chooseDeathMessage() {
        List<String> messages = this.getDeathMessages();
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        int rand = ThreadLocalRandom.current().nextInt(0, messages.size());
        return messages.get(rand);
    }

    public boolean createExplosion(Location location, Kingdom kingdom) {
        return this.createExplosion(location, kingdom, this.level);
    }

    public boolean createExplosion(Location location, Kingdom kingdom, int lvl) {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("explosion").getSection();
        if (section == null) {
            return false;
        }
        int fromLevel = section.getInt("level");
        if (lvl < fromLevel) {
            return false;
        }
        int fire = section.getInt("fire");
        return location.getWorld().createExplosion(location, (float)MathUtils.eval(section.getString("power"), kingdom, "lvl", lvl), lvl >= fire);
    }

    public void activate(LivingEntity target, Kingdom kingdom) {
        List<PotionEffect> hitEffects = this.getHitEffects();
        target.addPotionEffects(hitEffects);
        if (((TurretStyle)this.getStyle()).getOption("lingering").getBoolean()) {
            MineTurret.spawnLingeringPotion(this.getOrigin().toBukkitLocation(), hitEffects);
        }
        this.createExplosion(this.getOrigin().toBukkitLocation(), kingdom);
        this.applyKnockback(target, kingdom);
        if (this.canSetOnFire(kingdom)) {
            target.setFireTicks(200);
        }
        PlayerUtils.damageArmor(target, this.getArmorDamage(kingdom));
        if (this.lastActivation != null) {
            TurretFactory.DAMAGED.put((Object)target.getEntityId(), (Object)this.lastActivation);
        }
    }

    public @Nullable TurretActivateEvent getLastActivation() {
        return this.lastActivation;
    }

    public void setLastActivation(TurretActivateEvent lastActivation) {
        this.lastActivation = lastActivation;
    }

    @NotNull
    public KingdomBuildingHandler<Turret> getKingdomBlockHandler() {
        return TurretManager.INSTANCE;
    }
}

