/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.buildings.structures.RegulatorManager;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.Strings;

public class StructureTypeRegulator
extends StructureType {
    public StructureTypeRegulator() {
        super("regulator");
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        Regulator regulator = (Regulator)event.getKingdomItem();
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/regulator");
        if (gui == null) {
            return null;
        }
        gui.push("rules", () -> this.openRules(gui, player, regulator, context), new Object[0]).push("attributes", () -> this.openAttributes(gui, player, regulator, context), new Object[0]).push("interactions", () -> this.openInteractions(gui, player, regulator, context), new Object[0]);
        return context.finalizeGUI(gui);
    }

    public void openAttribute(InteractiveGUI parent, Player player, OfflinePlayer memberPlayer, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/attribute-editor");
        if (gui == null) {
            return;
        }
        gui.inherit(parent);
        gui.push("back", () -> this.open(context), new Object[0]);
        Set attributes = regulator.getAttributes().getOrDefault(memberPlayer.getUniqueId(), EnumSet.noneOf(Regulator.Attribute.class));
        for (Regulator.Attribute attribute : Regulator.Attribute.values()) {
            boolean enabled = attributes.contains((Object)attribute);
            gui.push(Strings.configOption(attribute), () -> {
                if (enabled) {
                    attributes.remove((Object)attribute);
                } else {
                    attributes.add(attribute);
                }
                regulator.getAttributes().put(memberPlayer.getUniqueId(), attributes);
                this.openAttribute(parent, player, memberPlayer, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public void openInteraction(InteractiveGUI parent, Player player, KingdomPlayer kp, OfflinePlayer memberPlayer, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/interaction-editor");
        if (gui == null) {
            return;
        }
        gui.inherit(parent);
        gui.push("back", () -> this.open(context), new Object[0]);
        Set<Regulator.Interactable> interactions = regulator.getInteractions().get(memberPlayer.getUniqueId());
        for (Regulator.Interactable interaction : Regulator.Interactable.values()) {
            boolean enabled = interactions.contains((Object)interaction);
            gui.push(Strings.configOption(interaction), () -> {
                if (enabled) {
                    interactions.remove((Object)interaction);
                } else {
                    interactions.add(interaction);
                }
                regulator.getInteractions().put(memberPlayer.getUniqueId(), interactions);
                this.openInteraction(parent, player, kp, memberPlayer, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public InteractiveGUI openInteractions(InteractiveGUI parent, Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/interactions");
        if (gui == null) {
            return null;
        }
        gui.inherit(parent);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, Set<Regulator.Interactable>> interactions = regulator.getInteractions();
        gui.push("back", () -> this.open(context), new Object[0]).push("add", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            KingdomsLang.REGULATOR_INTERACTIONS_ADD.sendMessage((CommandSender)player);
            gui.startConversation("add");
        }, input -> {
            OfflinePlayer add = PlayerUtils.getOfflinePlayer(input);
            if (add == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendMessage((CommandSender)player, "add", input);
                return;
            }
            if (add.getUniqueId().equals(player.getUniqueId())) {
                KingdomsLang.REGULATOR_INTERACTIONS_ADD_SELF.sendMessage((CommandSender)player);
                return;
            }
            if (interactions.containsKey(add.getUniqueId())) {
                KingdomsLang.REGULATOR_INTERACTIONS_ALREADY_ADDED.sendMessage((CommandSender)player, "add", add.getName());
                return;
            }
            interactions.put(add.getUniqueId(), EnumSet.noneOf(Regulator.Interactable.class));
            KingdomsLang.REGULATOR_INTERACTIONS_ADDED.sendMessage((CommandSender)player, "add", add.getName());
            gui.endConversation();
            this.openInteractions(parent, player, regulator, context);
        }, new Object[0]).push("remove-all", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            interactions.clear();
            this.openInteractions(parent, player, regulator, context);
        }, new Object[0]);
        ReusableOptionHandler holder = gui.getReusableOption("members");
        for (UUID member : interactions.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)member);
            holder.on(ClickType.LEFT, () -> this.openInteraction(parent, player, kp, offlinePlayer, regulator, context)).on(ClickType.RIGHT, () -> {
                interactions.remove(offlinePlayer.getUniqueId());
                KingdomsLang.REGULATOR_INTERACTIONS_REMOVED.sendMessage((CommandSender)player, new MessagePlaceholderProvider().withContext(offlinePlayer));
                this.openInteractions(parent, player, regulator, context);
            }).pushHead(offlinePlayer);
        }
        gui.open();
        return gui;
    }

    public InteractiveGUI openAttributes(InteractiveGUI parent, Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/attributes");
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, Set<Regulator.Attribute>> attributes = regulator.getAttributes();
        gui.inherit(parent);
        gui.push("back", () -> this.open(context), new Object[0]).push("add", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            KingdomsLang.REGULATOR_ATTRIBUTES_ADD.sendMessage((CommandSender)player);
            gui.startConversation("add");
        }, input -> {
            ConfigAccessor attrsSection;
            OfflinePlayer add = PlayerUtils.getOfflinePlayer(input);
            if (add == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendMessage((CommandSender)player, "add", input);
                return;
            }
            if (add.getUniqueId().equals(player.getUniqueId())) {
                KingdomsLang.REGULATOR_ATTRIBUTES_ADD_SELF.sendMessage((CommandSender)player);
                return;
            }
            if (attributes.containsKey(add.getUniqueId())) {
                KingdomsLang.REGULATOR_ATTRIBUTES_ALREADY_ADDED.sendMessage((CommandSender)player, "add", add.getName());
                return;
            }
            ConfigAccessor defaults = ((StructureStyle)((Structure)context.getEvent().getKingdomBlock()).getStyle()).getOption("defaults").noDefault().getSection();
            EnumSet<Regulator.Attribute> defaultAttributes = EnumSet.noneOf(Regulator.Attribute.class);
            if (defaults != null && (attrsSection = defaults.get("attributes").getSection()) != null) {
                ConfigSection defaultAttributesSection = attrsSection.getSection();
                for (String key : defaultAttributesSection.getKeys()) {
                    Regulator.Attribute attr = Regulator.Attribute.valueOf(key);
                    if (!defaultAttributesSection.getBoolean(key)) continue;
                    defaultAttributes.add(attr);
                }
            }
            attributes.put(add.getUniqueId(), defaultAttributes);
            KingdomsLang.REGULATOR_ATTRIBUTES_ADDED.sendMessage((CommandSender)player, "add", add.getName());
            gui.endConversation();
            this.openAttributes(parent, player, regulator, context);
        }, new Object[0]).push("remove-all", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            attributes.clear();
            this.openAttributes(parent, player, regulator, context);
        }, new Object[0]);
        ReusableOptionHandler holder = gui.getReusableOption("members");
        for (UUID member : attributes.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)member);
            holder.on(ClickType.LEFT, () -> this.openAttribute(parent, player, offlinePlayer, regulator, context)).on(ClickType.RIGHT, () -> {
                attributes.remove(offlinePlayer.getUniqueId());
                KingdomsLang.REGULATOR_ATTRIBUTES_REMOVED.sendMessage((CommandSender)player, new MessagePlaceholderProvider().withContext(offlinePlayer));
                this.openAttributes(parent, player, regulator, context);
            }).pushHead(offlinePlayer);
        }
        gui.open();
        return gui;
    }

    public InteractiveGUI openRules(InteractiveGUI parent, Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/rules");
        if (gui == null) {
            return null;
        }
        gui.inherit(parent);
        gui.push("back", () -> this.open(context), new Object[0]);
        for (Regulator.Rule rule : Regulator.Rule.values()) {
            String name = Strings.configOption(rule);
            boolean enabled = regulator.hasRule(rule);
            gui.push(name, () -> {
                if (enabled) {
                    regulator.getRules().remove((Object)rule);
                } else {
                    regulator.getRules().add(rule);
                    if (rule == Regulator.Rule.AUTO_FILL_TURRETS) {
                        Land land = regulator.getLand();
                        RegulatorManager.refillAllTurrets(land, land.getKingdom(), regulator);
                    }
                }
                this.openRules(parent, player, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
        return gui;
    }

    @Override
    public Regulator build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new Regulator(builder.getStyle(), builder.getLocation());
    }
}

