/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.UUID;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Outpost;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.managers.buildings.structures.OutpostMarket;
import org.kingdoms.utils.cooldown.BiCooldown;

public class StructureTypeOutpost
extends StructureType {
    private static final BiCooldown<UUID, String> PURCHASE_COOLDOWN = new BiCooldown();

    public static long getPurchaseCooldown(Kingdom kingdom, StructureStyle style, String name) {
        return PURCHASE_COOLDOWN.getTimeLeft(kingdom.getId(), style.getName() + ':' + name);
    }

    public static long addPurchaseCooldown(Kingdom kingdom, StructureStyle style, String name, long millisCooldown) {
        PURCHASE_COOLDOWN.add(kingdom.getId(), style.getName() + ':' + name, millisCooldown += StructureTypeOutpost.getPurchaseCooldown(kingdom, style, name));
        return millisCooldown;
    }

    public StructureTypeOutpost() {
        super("outpost");
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        return OutpostMarket.open(context);
    }

    @Override
    public boolean canBePlacedInUnclaimed() {
        return true;
    }

    @Override
    public Structure build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new Outpost(builder.getStyle(), builder.getLocation());
    }
}

