/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.FuelContainer;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class WarpPad
extends Structure
implements FuelContainer {
    private double fuel;

    public WarpPad(StructureStyle type, SimpleLocation location) {
        super(type, location);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + Double.hashCode(this.fuel);
        return result;
    }

    @Override
    public double getFuel() {
        return this.fuel;
    }

    @Override
    public void setFuel(double fuel) {
        this.fuel = fuel;
    }

    @Override
    public MessagePlaceholderProvider addMessageContextEdits(MessagePlaceholderProvider context, Kingdom kingdom) {
        return super.addMessageContextEdits(context, kingdom).raw("fuel", this.fuel).raw("max_fuel", this.eval(((StructureStyle)this.style).getOption("fuel", "capacity"), kingdom, this.level));
    }

    @Override
    public double getMaxFuel() {
        return this.eval(((StructureStyle)this.style).getOption("fuel", "capacity"), this.getLand().getKingdom(), this.level);
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setDouble("fuel", this.fuel);
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        this.fuel = context.getDataProvider().getDouble("fuel");
    }
}

