/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.managers.buildings.turrets.TurretLandCacheOptimizationWatcher;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.internal.tracker.TrackedSet;

public class Regulator
extends Structure {
    private Map<UUID, Set<Attribute>> attributes = new HashMap<UUID, Set<Attribute>>();
    private Map<UUID, Set<Interactable>> interactions = new HashMap<UUID, Set<Interactable>>();
    private Set<Rule> rules;
    public static final Namespace NS = Namespace.kingdoms("REGULATOR");

    private boolean onRuleChange(Rule rule, boolean added) {
        if (rule != Rule.DISABLE_TURRETS) {
            return true;
        }
        if (added) {
            TurretLandCacheOptimizationWatcher.uncache(this.getOrigin().toSimpleChunkLocation());
        } else {
            TurretLandCacheOptimizationWatcher.checked(this.getLand(), TurretLandCacheOptimizationWatcher.Factor.REGULATED);
        }
        return true;
    }

    public Regulator(StructureStyle type, SimpleLocation location) {
        super(type, location);
        this.setRules(new QuickEnumSet((Enum[])Rule.VALUES));
    }

    public static Interactable detectInteractableType(XMaterial material) {
        String name = material.name();
        if (name.contains("DOOR")) {
            return Interactable.DOORS;
        }
        if (name.contains("BUTTON") || name.contains("LEVER")) {
            return Interactable.BUTTONS_AND_LEVERS;
        }
        if (name.contains("ENCHANT") && name.contains("TABLE")) {
            return Interactable.ENCHANTMENT_TABLE;
        }
        if (name.contains("ANVIL")) {
            return Interactable.ANVILS;
        }
        if (name.contains("CHEST") || name.contains("BARREL")) {
            return Interactable.CHESTS;
        }
        if (name.contains("BED")) {
            return Interactable.BEDS;
        }
        if (name.contains("FURNACE")) {
            return Interactable.FURNACES;
        }
        if (name.contains("PLATE")) {
            return Interactable.PLATES;
        }
        return (Interactable)((Object)Enums.getIfPresent(Interactable.class, (String)name).orNull());
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Set<Rule> rules) {
        this.rules = Objects.requireNonNull(rules, "Regulator rules cannot be null");
        if (this.rules instanceof TrackedSet) {
            return;
        }
        this.rules = new TrackedSet<Rule>(this.rules, rule -> this.onRuleChange((Rule)((Object)rule), true), rule -> this.onRuleChange((Rule)((Object)rule), false));
    }

    public Map<UUID, Set<Interactable>> getInteractions() {
        return this.interactions;
    }

    public void setInteractions(Map<UUID, Set<Interactable>> interactions) {
        this.interactions = Objects.requireNonNull(interactions, "Regulator interaction settings cannot be null");
    }

    public boolean hasRule(Rule rule) {
        return this.rules.contains((Object)rule);
    }

    public Boolean hasAttribute(UUID player, Attribute attribute) {
        Set<Attribute> list = this.attributes.get(player);
        if (list == null) {
            return null;
        }
        return list.contains((Object)Attribute.ALL) || list.contains((Object)attribute);
    }

    public Boolean canInteract(UUID player, XMaterial material) {
        Set<Interactable> list = this.interactions.get(player);
        if (list == null) {
            return null;
        }
        if (list.contains((Object)Interactable.ALL)) {
            return true;
        }
        Interactable interactable = Regulator.detectInteractableType(material);
        return interactable != null && list.contains((Object)interactable);
    }

    public Map<UUID, Set<Attribute>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<UUID, Set<Attribute>> attributes) {
        this.attributes = Objects.requireNonNull(attributes, "Regulator attributes cannot be null");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + this.rules.hashCode();
        result = prime * result + this.attributes.hashCode();
        result = prime * result + this.interactions.hashCode();
        return result;
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.get("rules").setCollection(this.rules, (elementProvider, element) -> elementProvider.setString(element.name()));
        json.get("attributes").setMap(this.attributes, (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            keyProvider.getValueProvider().setCollection(value, (elementProvider, element) -> elementProvider.setString(element.name()));
        });
        json.get("interactions").setMap(this.interactions, (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            keyProvider.getValueProvider().setCollection(value, (elementProvider, element) -> elementProvider.setString(element.name()));
        });
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter provider = context.getDataProvider();
        this.setRules(provider.get("rules").asCollection(new QuickEnumSet((Enum[])Rule.values()), (c, elementProvider) -> {
            String str = elementProvider.asString();
            if (str != null) {
                c.add(Rule.valueOf(str));
            }
        }));
        this.setAttributes(provider.get("attributes").asMap(new HashMap(), (map, key, value) -> {
            QuickEnumSet attrs = value.asCollection(new QuickEnumSet((Enum[])Attribute.values()), (c, elementProvider) -> {
                String str = elementProvider.asString();
                if (str != null) {
                    c.add(Attribute.valueOf(str));
                }
            });
            map.put(key.asUUID(), attrs);
        }));
        this.setInteractions(provider.get("interactions").asMap(new HashMap(), (map, key, value) -> {
            QuickEnumSet interactables = value.asCollection(new QuickEnumSet((Enum[])Interactable.values()), (c, elementProvider) -> c.add(Interactable.valueOf(elementProvider.asString())));
            map.put(key.asUUID(), interactables);
        }));
    }

    public static enum Rule {
        DISABLE_MOB_SPAWNING,
        DISABLE_ANIMAL_SPAWNING,
        DISABLE_TURRETS,
        AUTO_FILL_TURRETS,
        ALLOW_EXPLOSIONS,
        ALLOW_FIRE;

        private static final Rule[] VALUES;

        static {
            VALUES = Rule.values();
        }
    }

    public static enum Interactable {
        ALL,
        DOORS,
        BUTTONS_AND_LEVERS,
        SHULKER_BOXES,
        ENCHANTMENT_TABLE,
        CRAFTING_TABLE,
        CHESTS,
        BEDS,
        LOOM,
        JIGSAW,
        HOPPER,
        DISPENSER,
        SMOKER,
        FURNACES,
        DROPPER,
        BEACON,
        ANVILS,
        BREWING_STAND,
        CARTOGRAPHY_TABLES,
        SMITHING_TABLE,
        PLATES;

    }

    public static enum Attribute {
        ALL,
        BUILD,
        FLY,
        TURRET_CEASEFIRE,
        MANAGE_TURRETS;

    }
}

