/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.JailSession;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.time.TimeRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/kingdoms/constants/land/structures/objects/JailStructure;", "Lorg/kingdoms/constants/land/structures/Structure;", "style", "Lorg/kingdoms/constants/land/structures/StructureStyle;", "location", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "<init>", "(Lorg/kingdoms/constants/land/structures/StructureStyle;Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "jailSession", "Lorg/kingdoms/constants/land/structures/JailSession;", "getJailSession", "()Lorg/kingdoms/constants/land/structures/JailSession;", "setJailSession", "(Lorg/kingdoms/constants/land/structures/JailSession;)V", "jailSpawn", "Lorg/bukkit/Location;", "getJailSpawn", "()Lorg/bukkit/Location;", "setJailSpawn", "(Lorg/bukkit/Location;)V", "addMessageContextEdits", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "context", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "jail", "", "remove", "Lorg/kingdoms/events/items/KingdomItemBreakEvent;", "Lorg/kingdoms/events/items/KingdomItemRemoveContext;", "release", "hashCode", "", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
@SourceDebugExtension(value={"SMAP\nJailStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JailStructure.kt\norg/kingdoms/constants/land/structures/objects/JailStructure\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n39#2:100\n38#2:105\n40#2:106\n40#2:107\n38#2:108\n1557#3:101\n1628#3,3:102\n*S KotlinDebug\n*F\n+ 1 JailStructure.kt\norg/kingdoms/constants/land/structures/objects/JailStructure\n*L\n31#1:100\n44#1:105\n45#1:106\n56#1:107\n57#1:108\n37#1:101\n37#1:102,3\n*E\n"})
public final class JailStructure
extends Structure {
    @Nullable
    private JailSession jailSession;
    @Nullable
    private Location jailSpawn;

    public JailStructure(@NotNull StructureStyle style, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(style, location);
    }

    @Nullable
    public final JailSession getJailSession() {
        return this.jailSession;
    }

    public final void setJailSession(@Nullable JailSession jailSession) {
        this.jailSession = jailSession;
    }

    @Nullable
    public final Location getJailSpawn() {
        return this.jailSpawn;
    }

    public final void setJailSpawn(@Nullable Location location) {
        this.jailSpawn = location;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @MustBeInvokedByOverriders
    @NotNull
    public MessagePlaceholderProvider addMessageContextEdits(@NotNull MessagePlaceholderProvider context, @NotNull Kingdom kingdom) {
        MessagePlaceholderProvider messagePlaceholderProvider;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
        MessagePlaceholderProvider $this$addMessageContextEdits_u24lambda_u241 = messagePlaceholderProvider = super.addMessageContextEdits(context, kingdom);
        boolean bl = false;
        if (this.jailSession != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
            UUID $this$asOfflinePlayer$iv = jailSession2.getJailedPlayer();
            boolean $i$f$asOfflinePlayer22 = false;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)$this$asOfflinePlayer$iv);
            Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
            OfflinePlayer jailedPlayer = offlinePlayer;
            $this$addMessageContextEdits_u24lambda_u241.withContext(jailedPlayer);
            $this$addMessageContextEdits_u24lambda_u241.raw("jail_player", jailedPlayer.getName());
            $this$addMessageContextEdits_u24lambda_u241.raw("jail_period", jailSession2.getJailPeriod().toMillis());
            $this$addMessageContextEdits_u24lambda_u241.raw("jail_bail", jailSession2.getBail());
            $this$addMessageContextEdits_u24lambda_u241.raw("jail_since", jailSession2.getSince());
            Iterable this_$iv = jailSession2.getFreeHours();
            String string = "jail_free_hours";
            MessagePlaceholderProvider messagePlaceholderProvider2 = $this$addMessageContextEdits_u24lambda_u241;
            boolean $i$f$map = false;
            void $i$f$asOfflinePlayer22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                TimeRange timeRange = (TimeRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(x.getFrom() + " - " + x.getTo());
            }
            collection = (List)destination$iv$iv;
            messagePlaceholderProvider2.parse(string, collection);
        }
        MessagePlaceholderProvider messagePlaceholderProvider3 = messagePlaceholderProvider;
        Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider3, (String)"apply(...)");
        return messagePlaceholderProvider3;
    }

    public final void jail(@NotNull JailSession jailSession) {
        Intrinsics.checkNotNullParameter((Object)jailSession, (String)"jailSession");
        this.jailSession = jailSession;
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        UUID $this$asPlayer$iv = jailSession.getJailedPlayer();
        boolean $i$f$asPlayer = false;
        Player player = Bukkit.getPlayer((UUID)$this$asPlayer$iv);
        if (player != null) {
            Location location = this.jailSpawn;
            Intrinsics.checkNotNull((Object)location);
            player.teleport(location);
        }
        KingdomsBukkitExtensions kingdomsBukkitExtensions2 = KingdomsBukkitExtensions.INSTANCE;
        UUID $this$asKingdomPlayer$iv = jailSession.getJailedPlayer();
        boolean $i$f$asKingdomPlayer = false;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        kingdomPlayer.setJailCell(this.origin);
    }

    @Override
    @NotNull
    public KingdomItemBreakEvent<?> remove(@NotNull KingdomItemRemoveContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.jailSession != null) {
            this.release();
        }
        KingdomItemBreakEvent<?> kingdomItemBreakEvent = super.remove(context);
        Intrinsics.checkNotNullExpressionValue(kingdomItemBreakEvent, (String)"remove(...)");
        return kingdomItemBreakEvent;
    }

    public final void release() {
        block0: {
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
            Object $this$asKingdomPlayer$iv = jailSession2.getJailedPlayer();
            boolean $i$f$asKingdomPlayer = false;
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((UUID)$this$asKingdomPlayer$iv);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            kingdomPlayer.setJailCell(null);
            $this$asKingdomPlayer$iv = KingdomsBukkitExtensions.INSTANCE;
            UUID $this$asPlayer$iv = jailSession2.getJailedPlayer();
            boolean $i$f$asPlayer = false;
            Player player = Bukkit.getPlayer((UUID)$this$asPlayer$iv);
            if (player == null) break block0;
            World world = this.origin.getBukkitWorld();
            Intrinsics.checkNotNull((Object)world);
            player.teleport(world.getSpawnLocation());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        if (this.jailSession != null) {
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            result = prime * result + jailSession2.getJailedPlayer().hashCode();
            result = prime * result + Double.hashCode(jailSession2.getBail());
            result = prime * result + jailSession2.getRequiredItems().size();
            result = prime * result + jailSession2.getFreeHours().size();
        }
        return result;
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        if (this.jailSession != null) {
            SectionableDataSetter sectionableDataSetter;
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            SectionableDataSetter $this$serialize_u24lambda_u242 = sectionableDataSetter = json;
            boolean bl = false;
            $this$serialize_u24lambda_u242.setUUID("jailed", jailSession2.getJailedPlayer());
            $this$serialize_u24lambda_u242.setLong("jailPeriod", jailSession2.getJailPeriod().toMillis());
            $this$serialize_u24lambda_u242.setLong("jailedSince", jailSession2.getSince());
            $this$serialize_u24lambda_u242.setDouble("bail", jailSession2.getBail());
            json.get("freeHours").setCollection((Collection)jailSession2.getFreeHours(), JailStructure::serialize$lambda$4);
        }
    }

    private static final void serialize$lambda$4(SectionCreatableDataSetter eleProvider, TimeRange ele) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)eleProvider, (String)"eleProvider");
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        TimeRange timeRange = ele;
        LocalTime from = timeRange.component1();
        LocalTime to = timeRange.component2();
        SectionableDataSetter $this$serialize_u24lambda_u244_u24lambda_u243 = sectionableDataSetter = eleProvider.createSection();
        boolean bl = false;
        $this$serialize_u24lambda_u244_u24lambda_u243.setString("from", "" + from.getHour() + ':' + from.getMinute());
        $this$serialize_u24lambda_u244_u24lambda_u243.setString("to", "" + to.getHour() + ':' + to.getMinute());
    }
}

