/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import java.util.Map;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemPlaceContext;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.buildings.structures.StructureManager;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.internal.functional.Fn;

public class Structure
extends KingdomBuilding<StructureStyle> {
    private String name;

    public Structure(String world, int x, int y, int z, StructureStyle type) {
        this(type, new SimpleLocation(world, x, y, z));
    }

    public Structure(@NonNull StructureStyle style, @NonNull SimpleLocation location) {
        super(style, location);
        this.name = style.getOption("default-name").getString();
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        Land land = this.getLand();
        Kingdom kingdom = land.getKingdom();
        if (kingdom != null) {
            boolean isNexus = false;
            if (((StructureType)((StructureStyle)this.style).getType()).isNationalNexus()) {
                Nation nation = kingdom.getNation();
                isNexus = true;
                if (nation != null) {
                    nation.setNexus(null);
                }
            } else if (((StructureType)((StructureStyle)this.style).getType()).isNexus()) {
                isNexus = true;
                kingdom.setNexus(null);
            }
            if (isNexus) {
                context.setDropsItem(false);
            }
        }
        return super.remove(context);
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameOrDefault() {
        if (this.name != null) {
            return this.name;
        }
        return ((StructureStyle)this.style).getOption("default-name").getString();
    }

    @Override
    public KingdomItemPlaceEvent<Structure> place(KingdomItemPlaceContext context) {
        KingdomItemPlaceEvent<Structure> event = super.place(context);
        if (context.getAddData()) {
            this.modifyData(this.getLand(), true);
        }
        return event;
    }

    @Override
    protected Map<BlockVector3, KingdomBlock> getDataMap(Land land) {
        return (Map)Fn.cast(land.unsafeGetStructures());
    }

    @Override
    @MustBeInvokedByOverriders
    public MessagePlaceholderProvider addMessageContextEdits(MessagePlaceholderProvider context, Kingdom kingdom) {
        MessagePlaceholderProvider edits = super.addMessageContextEdits(context, kingdom);
        if (this.name != null) {
            edits.parse("structure-custom-name", this.name);
        } else {
            edits.raw("structure-custom-name", KingdomsLang.NONE);
        }
        return edits;
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter provider = context.getDataProvider();
        provider.setString("name", this.name);
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter provider = context.getDataProvider();
        this.name = provider.getString("name");
    }

    public KingdomBuildingHandler<Structure> getKingdomBlockHandler() {
        return StructureManager.INSTANCE;
    }
}

