/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.singleblocked;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingArchitect;
import org.kingdoms.constants.land.building.BuildingConstructionArchitect;
import org.kingdoms.constants.land.building.BuildingConstructionException;
import org.kingdoms.constants.land.building.BuildingConstructionListener;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.BuildingDemolition;
import org.kingdoms.constants.land.building.BuildingDeserializationContext;
import org.kingdoms.constants.land.building.Region;
import org.kingdoms.constants.land.building.RegionFilter;
import org.kingdoms.constants.land.building.base.AbstractBuildingConstruction;
import org.kingdoms.constants.land.building.info.BuildingConstructionValidation;
import org.kingdoms.constants.land.building.info.BuildingSchematic;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.constants.land.building.info.block.AirBlockInfo;
import org.kingdoms.constants.land.building.info.block.BlockInfo;
import org.kingdoms.constants.land.building.singleblocked.SingleBlockedBuilding;
import org.kingdoms.constants.land.building.singleblocked.SingleBlockedRegion;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.main.KLogger;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020.H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuildingConstruction;", "Lorg/kingdoms/constants/land/building/base/AbstractBuildingConstruction;", "origin", "Lorg/kingdoms/server/location/BlockLocation3;", "type", "Lorg/kingdoms/constants/land/building/BuildingConstructionType;", "state", "Lorg/kingdoms/constants/land/building/BuildingConstructionState;", "facing", "Lorg/kingdoms/server/location/Direction;", "timePassed", "Ljava/time/Duration;", "wasBlockChanged", "", "<init>", "(Lorg/kingdoms/server/location/BlockLocation3;Lorg/kingdoms/constants/land/building/BuildingConstructionType;Lorg/kingdoms/constants/land/building/BuildingConstructionState;Lorg/kingdoms/server/location/Direction;Ljava/time/Duration;Z)V", "getWasBlockChanged", "()Z", "setWasBlockChanged", "(Z)V", "getArchitect", "Lorg/kingdoms/constants/land/building/BuildingArchitect;", "blockInfo", "Lorg/kingdoms/constants/land/building/info/block/BlockInfo;", "_region", "Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedRegion;", "getRegion", "Lorg/kingdoms/constants/land/building/Region;", "validateBlocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "Lorg/kingdoms/constants/land/building/info/BuildingConstructionValidation;", "demolish", "Lorg/kingdoms/constants/land/building/BuildingDemolition;", "filter", "Lorg/kingdoms/constants/land/building/RegionFilter;", "onChunkLoad", "chunk", "Lorg/kingdoms/server/location/BlockVector2;", "changeBlock", "", "prepare", "settings", "Lorg/kingdoms/constants/land/building/info/BuildingSettings;", "onTimerFinish", "asFinishedBuilding", "Lorg/kingdoms/constants/land/building/Building;", "Arch", "core"})
@SourceDebugExtension(value={"SMAP\nSingleBlockedBuildingConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleBlockedBuildingConstruction.kt\norg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuildingConstruction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1863#2,2:166\n*S KotlinDebug\n*F\n+ 1 SingleBlockedBuildingConstruction.kt\norg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuildingConstruction\n*L\n131#1:166,2\n*E\n"})
public final class SingleBlockedBuildingConstruction
extends AbstractBuildingConstruction {
    private boolean wasBlockChanged;
    private BlockInfo blockInfo;
    @NotNull
    private final SingleBlockedRegion _region;

    public SingleBlockedBuildingConstruction(@NotNull BlockLocation3 origin, @NotNull BuildingConstructionType type, @NotNull BuildingConstructionState state, @NotNull Direction facing, @NotNull Duration timePassed, boolean wasBlockChanged) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)timePassed, (String)"timePassed");
        super(origin, type, state, null, facing, timePassed);
        this.wasBlockChanged = wasBlockChanged;
        this._region = new SingleBlockedRegion(BlockVector3.Companion.of(origin));
    }

    public final boolean getWasBlockChanged() {
        return this.wasBlockChanged;
    }

    public final void setWasBlockChanged(boolean bl) {
        this.wasBlockChanged = bl;
    }

    @Override
    @NotNull
    public BuildingArchitect getArchitect() {
        return Arch.INSTANCE;
    }

    @Override
    @NotNull
    public Region getRegion() {
        return this._region;
    }

    @Override
    @NotNull
    public Map<BlockVector3, BuildingConstructionValidation> validateBlocks() {
        Map validated = new HashMap();
        org.kingdoms.server.location.World world = this.getOrigin$core().getWorld();
        Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type org.kingdoms.platform.bukkit.location.BukkitWorld");
        World bukkitWorld = ((BukkitWorld)world).getWorld();
        for (BlockVector3 block : this.getRegion().getBlocks()) {
            Block bukkitBlock;
            Intrinsics.checkNotNullExpressionValue((Object)bukkitWorld.getBlockAt(new Location(bukkitWorld, (double)block.getX(), (double)block.getY(), (double)block.getZ())), (String)"getBlockAt(...)");
            boolean canBePlaced = XTag.AIR.isTagged((XBase)XMaterial.matchXMaterial((Material)bukkitBlock.getType()));
            String string = canBePlaced ? "ok" : "conflict";
            BlockInfo blockInfo = this.blockInfo;
            if (blockInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"blockInfo");
                blockInfo = null;
            }
            BuildingConstructionValidation validation = new BuildingConstructionValidation(canBePlaced, string, blockInfo);
            validated.put(block, validation);
        }
        return validated;
    }

    @Override
    @NotNull
    public synchronized BuildingDemolition demolish(@Nullable RegionFilter filter) {
        this.prepareForDemolition();
        BlockLocation3 blockLocation3 = this.getOrigin$core();
        Direction direction = this.getFacing$core();
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        SingleBlockedBuildingConstruction demolition = new SingleBlockedBuildingConstruction(blockLocation3, BuildingConstructionType.DEMOLISHING, BuildingConstructionState.NONE, direction, duration, false);
        demolition.prepare(this.getSettings$core());
        return demolition;
    }

    @Override
    public synchronized boolean onChunkLoad(@NotNull BlockVector2 chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (!this.wasBlockChanged) {
            this.changeBlock();
            if (this.getTimerFinished()) {
                this.finish();
            }
        }
        return super.onChunkLoad(chunk);
    }

    private final void changeBlock() {
        Block block = BukkitAdapter.adapt(this.getOrigin$core()).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        BlockInfo blockInfo = this.blockInfo;
        if (blockInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockInfo");
            blockInfo = null;
        }
        blockInfo.changeBlock(block2);
        Iterable $this$forEach$iv = this.getListeners().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildingConstructionListener it = (BuildingConstructionListener)element$iv;
            boolean bl = false;
            try {
                it.onBlockChange(block2);
            }
            catch (Throwable ex) {
                KLogger.error("An error occurred while calling onBlockChange for " + it + " -> " + this);
                ex.printStackTrace();
            }
        }
        this.wasBlockChanged = true;
    }

    @Override
    public synchronized void prepare(@NotNull BuildingSettings settings) {
        BlockInfo blockInfo;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.prepare(settings);
        String[] stringArray = new String[]{"block"};
        ConfigSection block = settings.getSettings().getSection(stringArray);
        String string = block.getString("material");
        Intrinsics.checkNotNull((Object)string);
        XMaterial material = (XMaterial)XMaterial.matchXMaterial((String)string).orElseThrow(() -> SingleBlockedBuildingConstruction.prepare$lambda$1(this, block));
        String skull = block.getString("skull");
        if (this.getType() == BuildingConstructionType.DEMOLISHING) {
            blockInfo = AirBlockInfo.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)material);
            blockInfo = BlockInfo.Companion.create(material, skull, this.getFacing$core());
        }
        this.blockInfo = blockInfo;
    }

    @Override
    public boolean onTimerFinish() {
        return this.wasBlockChanged;
    }

    @Override
    @NotNull
    public synchronized Building asFinishedBuilding() {
        this.prepareAsFinished();
        return new SingleBlockedBuilding(this.getOrigin$core(), this.getFacing$core(), this.getSettings$core());
    }

    private static final BuildingConstructionException prepare$lambda$1(SingleBlockedBuildingConstruction this$0, ConfigSection $block) {
        return new BuildingConstructionException(this$0, "Unknown material for block: " + $block.getString("material") + ": " + this$0, null, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0016\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuildingConstruction$Arch;", "Lorg/kingdoms/constants/land/building/BuildingConstructionArchitect;", "<init>", "()V", "NAMESPACE", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "newBuilding", "Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuildingConstruction;", "info", "Lorg/kingdoms/constants/land/building/info/BuildingSchematic;", "getNamespace", "deserialize", "context", "Lorg/kingdoms/constants/land/building/BuildingDeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "core"})
    public static final class Arch
    implements BuildingConstructionArchitect {
        @NotNull
        public static final Arch INSTANCE = new Arch();
        @JvmField
        @NotNull
        public static final Namespace NAMESPACE;

        private Arch() {
        }

        @Override
        @NotNull
        public SingleBlockedBuildingConstruction newBuilding(@NotNull BuildingSchematic info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BlockLocation3 blockLocation3 = info.getOrigin();
            BuildingConstructionType buildingConstructionType = info.getType();
            Direction direction = info.getFacing();
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            SingleBlockedBuildingConstruction building = new SingleBlockedBuildingConstruction(blockLocation3, buildingConstructionType, BuildingConstructionState.NONE, direction, duration, false);
            building.prepare(info.getSettings());
            return building;
        }

        @Override
        @NotNull
        public Namespace getNamespace() {
            return NAMESPACE;
        }

        @Override
        @NotNull
        public SingleBlockedBuildingConstruction deserialize(@NotNull BuildingDeserializationContext<SectionableDataGetter> context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            SectionableDataGetter $this$deserialize_u24lambda_u240 = (SectionableDataGetter)context.getDataProvider();
            boolean bl = false;
            BlockLocation3 origin = context.getOrigin();
            String string = $this$deserialize_u24lambda_u240.getString("facing");
            Intrinsics.checkNotNull((Object)string);
            Direction direction = Direction.Companion.fromString(string);
            Intrinsics.checkNotNull((Object)direction);
            Direction facing = direction;
            long timePassed = $this$deserialize_u24lambda_u240.getLong("timePassed");
            String string2 = $this$deserialize_u24lambda_u240.getString("type");
            Intrinsics.checkNotNull((Object)string2);
            BuildingConstructionType type = BuildingConstructionType.valueOf(string2);
            String string3 = $this$deserialize_u24lambda_u240.getString("state");
            Intrinsics.checkNotNull((Object)string3);
            BuildingConstructionState state = BuildingConstructionState.valueOf(string3);
            Duration duration = Duration.ofMillis(timePassed);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            return new SingleBlockedBuildingConstruction(origin, type, state, facing, duration, true);
        }

        static {
            Namespace namespace = Namespace.kingdoms("SINGLE_BLOCKED_CONSTRUCTION");
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
            NAMESPACE = namespace;
        }
    }
}

