/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.kingdoms.constants.land.building.schema.BuildingMapping;
import org.kingdoms.constants.land.building.schema.EvaluatedBuildingMapping;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.string.StringMatcher;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0002\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/constants/land/building/schema/BuildingSchema;", "", "origin", "Lorg/kingdoms/server/location/BlockVector2;", "blocksPattern", "", "Lorg/kingdoms/server/location/BlockVector3;", "", "mappings", "Lorg/kingdoms/constants/land/building/schema/BuildingMapping;", "<init>", "(Lorg/kingdoms/server/location/BlockVector2;Ljava/util/Map;Ljava/util/Map;)V", "getOrigin", "()Lorg/kingdoms/server/location/BlockVector2;", "getBlocksPattern", "()Ljava/util/Map;", "getMappings", "locateBlocks", "Lorg/kingdoms/constants/land/building/schema/EvaluatedBuildingMapping;", "Lorg/kingdoms/server/location/BlockLocation3;", "Companion", "core"})
public final class BuildingSchema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockVector2 origin;
    @NotNull
    private final Map<BlockVector3, Character> blocksPattern;
    @NotNull
    private final Map<Character, BuildingMapping> mappings;

    public BuildingSchema(@NotNull BlockVector2 origin, @NotNull Map<BlockVector3, Character> blocksPattern, @NotNull Map<Character, BuildingMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(blocksPattern, (String)"blocksPattern");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.origin = origin;
        this.blocksPattern = blocksPattern;
        this.mappings = mappings;
    }

    @NotNull
    public final BlockVector2 getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Map<BlockVector3, Character> getBlocksPattern() {
        return this.blocksPattern;
    }

    @NotNull
    public final Map<Character, BuildingMapping> getMappings() {
        return this.mappings;
    }

    @NotNull
    public final Map<BlockVector3, EvaluatedBuildingMapping> locateBlocks(@NotNull BlockLocation3 origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Map located = new HashMap();
        World world = BukkitAdapter.adapt(origin.getWorld());
        for (Map.Entry<BlockVector3, Character> entry : this.blocksPattern.entrySet()) {
            Block block;
            BuildingMapping mapping;
            BlockVector3 relativeLoc = entry.getKey();
            char symbol = entry.getValue().charValue();
            BlockLocation3 absolute = origin.add(relativeLoc.getX() - this.origin.getX(), relativeLoc.getY(), relativeLoc.getZ() - this.origin.getZ());
            Intrinsics.checkNotNull((Object)this.mappings.get(Character.valueOf(symbol)));
            Intrinsics.checkNotNullExpressionValue((Object)world.getBlockAt(BukkitAdapter.adapt(absolute)), (String)"getBlockAt(...)");
            boolean matches = StringMatcher.group((Collection<StringMatcher>)mapping.getAcceptedMaterials()).matches(XMaterial.matchXMaterial((Material)block.getType()).name());
            located.put(absolute.toVector(), new EvaluatedBuildingMapping(matches, mapping));
        }
        return located;
    }

    @JvmStatic
    @NotNull
    public static final BuildingSchema parse(@NotNull ConfigSection section) {
        return Companion.parse(section);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/constants/land/building/schema/BuildingSchema$Companion;", "", "<init>", "()V", "parse", "Lorg/kingdoms/constants/land/building/schema/BuildingSchema;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    @SourceDebugExtension(value={"SMAP\nBuildingSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingSchema.kt\norg/kingdoms/constants/land/building/schema/BuildingSchema$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1557#2:81\n1628#2,3:82\n*S KotlinDebug\n*F\n+ 1 BuildingSchema.kt\norg/kingdoms/constants/land/building/schema/BuildingSchema$Companion\n*L\n62#1:81\n62#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BuildingSchema parse(@NotNull ConfigSection section) {
            char[] cArray;
            Object object;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            String[] stringArray = new String[]{"origin"};
            List<Integer> list = section.getIntegerList(stringArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getIntegerList(...)");
            List<Integer> origin = list;
            stringArray = new String[]{"blocks"};
            ConfigSection blocks = section.getSection(stringArray);
            String[] stringArray2 = new String[]{"mappings"};
            ConfigSection mappingsOpt = section.getSection(stringArray2);
            Map blocksPattern = new HashMap();
            for (String yKey : blocks.getKeys()) {
                String pattern;
                Intrinsics.checkNotNull((Object)blocks.getString(yKey));
                Intrinsics.checkNotNull((Object)yKey);
                int y = Integer.parseInt(yKey);
                String[] stringArray3 = new String[]{"\n"};
                object = ((Iterable)StringsKt.split$default((CharSequence)pattern, (String[])stringArray3, (boolean)false, (int)0, (int)6, null)).iterator();
                int n = 0;
                while (object.hasNext()) {
                    int x = n++;
                    String line = (String)object.next();
                    Intrinsics.checkNotNullExpressionValue((Object)line.toCharArray(), (String)"toCharArray(...)");
                    int n2 = cArray.length;
                    block5: for (int i = 0; i < n2; ++i) {
                        int z = i;
                        char c = cArray[i];
                        switch (c) {
                            case ' ': 
                            case 'x': {
                                continue block5;
                            }
                            default: {
                                Character c2 = Character.valueOf(c);
                                blocksPattern.put(BlockVector3.Companion.of(x, y, z), c2);
                            }
                        }
                    }
                }
            }
            Map mappings = new HashMap();
            for (String key : mappingsOpt.getKeys()) {
                Collection<StringMatcher> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object = new String[]{key};
                ConfigSection mapping = mappingsOpt.getSection((String[])object);
                object = mappings;
                Character c = Character.valueOf(key.charAt(0));
                char c3 = key.charAt(0);
                String string = mapping.getString("displayname");
                Intrinsics.checkNotNull((Object)string);
                Messenger messenger = new StaticMessenger(string);
                String string2 = mapping.getString("mismatch-message");
                Intrinsics.checkNotNull((Object)string2);
                Messenger messenger2 = new StaticMessenger(string2);
                String[] line = new String[]{"accepted-materials"};
                List<String> list2 = mapping.getStringList(line);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getStringList(...)");
                Iterable x = list2;
                Messenger messenger3 = messenger2;
                Messenger messenger4 = messenger;
                char c4 = c3;
                boolean $i$f$map = false;
                cArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string3 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringMatcher.fromString((String)it));
                }
                Collection<StringMatcher> collection2 = collection = (List)destination$iv$iv;
                Messenger messenger5 = messenger3;
                Messenger messenger6 = messenger4;
                char c5 = c4;
                BuildingMapping buildingMapping = new BuildingMapping(c5, messenger6, messenger5, (List<? extends StringMatcher>)collection2);
                object.put(c, buildingMapping);
            }
            Integer n = origin.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            int n3 = ((Number)n).intValue();
            Integer n4 = origin.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"get(...)");
            return new BuildingSchema(BlockVector2.Companion.of(n3, ((Number)n4).intValue()), blocksPattern, mappings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

