/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.info;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.info.BuildingFunctionalPoint;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.Serializable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.cache.single.CachedSupplier;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00050\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010\f0\f0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lorg/kingdoms/constants/land/building/info/BuildingSettings;", "", "schematic", "", "buildDuration", "", "Lorg/kingdoms/constants/land/building/BuildingConstructionType;", "Lorg/kingdoms/utils/compilers/expressions/MathExpression;", "holograms", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "messageContextProvider", "Ljava/util/function/Supplier;", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "preview", "Lorg/kingdoms/constants/land/building/info/BuildingSettings$Validation;", "functionalPoints", "Lorg/kingdoms/server/location/BlockVector3;", "", "Lorg/kingdoms/constants/land/building/info/BuildingFunctionalPoint;", "settings", "Lorg/kingdoms/utils/config/ConfigSection;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/function/Supplier;Ljava/util/Map;Ljava/util/Map;Lorg/kingdoms/utils/config/ConfigSection;)V", "getSchematic", "()Ljava/lang/String;", "getBuildDuration", "()Ljava/util/Map;", "getHolograms", "getPreview", "getFunctionalPoints", "getSettings", "()Lorg/kingdoms/utils/config/ConfigSection;", "Lorg/kingdoms/utils/cache/single/CachedSupplier;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "messageContext", "getMessageContext", "()Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "ValidationType", "Validation", "Companion", "core"})
public class BuildingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String schematic;
    @NotNull
    private final Map<BuildingConstructionType, MathExpression> buildDuration;
    @NotNull
    private final Map<String, Map<String, GroupedHologram>> holograms;
    @NotNull
    private final Map<String, Validation> preview;
    @NotNull
    private final Map<BlockVector3, List<BuildingFunctionalPoint>> functionalPoints;
    @NotNull
    private final ConfigSection settings;
    @NotNull
    private final CachedSupplier<MessagePlaceholderProvider> messageContextProvider;

    public BuildingSettings(@NotNull String schematic, @NotNull Map<BuildingConstructionType, ? extends MathExpression> buildDuration, @NotNull Map<String, ? extends Map<String, GroupedHologram>> holograms, @NotNull Supplier<MessagePlaceholderProvider> messageContextProvider, @NotNull Map<String, ? extends Validation> preview, @NotNull Map<BlockVector3, ? extends List<? extends BuildingFunctionalPoint>> functionalPoints, @NotNull ConfigSection settings) {
        Intrinsics.checkNotNullParameter((Object)schematic, (String)"schematic");
        Intrinsics.checkNotNullParameter(buildDuration, (String)"buildDuration");
        Intrinsics.checkNotNullParameter(holograms, (String)"holograms");
        Intrinsics.checkNotNullParameter(messageContextProvider, (String)"messageContextProvider");
        Intrinsics.checkNotNullParameter(preview, (String)"preview");
        Intrinsics.checkNotNullParameter(functionalPoints, (String)"functionalPoints");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.schematic = schematic;
        this.buildDuration = buildDuration;
        this.holograms = holograms;
        this.preview = preview;
        this.functionalPoints = functionalPoints;
        this.settings = settings;
        this.messageContextProvider = new CachedSupplier<MessagePlaceholderProvider>(messageContextProvider);
    }

    @NotNull
    public final String getSchematic() {
        return this.schematic;
    }

    @NotNull
    public final Map<BuildingConstructionType, MathExpression> getBuildDuration() {
        return this.buildDuration;
    }

    @NotNull
    public final Map<String, Map<String, GroupedHologram>> getHolograms() {
        return this.holograms;
    }

    @NotNull
    public final Map<String, Validation> getPreview() {
        return this.preview;
    }

    @NotNull
    public final Map<BlockVector3, List<BuildingFunctionalPoint>> getFunctionalPoints() {
        return this.functionalPoints;
    }

    @NotNull
    public final ConfigSection getSettings() {
        return this.settings;
    }

    @NotNull
    public final MessagePlaceholderProvider getMessageContext() {
        MessagePlaceholderProvider messagePlaceholderProvider = this.messageContextProvider.get();
        Intrinsics.checkNotNull((Object)messagePlaceholderProvider);
        return messagePlaceholderProvider;
    }

    @JvmStatic
    public static final boolean isFunctionalPoint(@NotNull SimpleLocation location, @NotNull String type) {
        return Companion.isFunctionalPoint(location, type);
    }

    @JvmStatic
    @Nullable
    public static final BuildingFunctionalPoint getFunctionalPoint(@NotNull SimpleLocation location, @NotNull String type) {
        return Companion.getFunctionalPoint(location, type);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/constants/land/building/info/BuildingSettings$Companion;", "", "<init>", "()V", "isFunctionalPoint", "", "location", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "type", "", "getFunctionalPoint", "Lorg/kingdoms/constants/land/building/info/BuildingFunctionalPoint;", "core"})
    @SourceDebugExtension(value={"SMAP\nBuildingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingSettings.kt\norg/kingdoms/constants/land/building/info/BuildingSettings$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isFunctionalPoint(@NotNull SimpleLocation location, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.getFunctionalPoint(location, type) != null;
        }

        @JvmStatic
        @Nullable
        public final BuildingFunctionalPoint getFunctionalPoint(@NotNull SimpleLocation location, @NotNull String type) {
            Object v4;
            block7: {
                List<BuildingFunctionalPoint> list;
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Land land = location.toSimpleChunkLocation().getLand();
                if (land == null) {
                    return null;
                }
                Land land2 = land;
                BlockVector3 locVector = location.toBlockVector();
                KingdomBlock kingdomBlock = land2.getKingdomBlocks().get(locVector);
                if (kingdomBlock == null) {
                    return null;
                }
                KingdomBlock kingdomBlock2 = kingdomBlock;
                Serializable serializable = kingdomBlock2 instanceof KingdomBuilding ? (KingdomBuilding)kingdomBlock2 : null;
                if (serializable == null || (serializable = ((KingdomBuilding)serializable).getBuilding()) == null) {
                    return null;
                }
                Serializable building = serializable;
                BuildingSettings settings = building.getSettings();
                Map<BlockVector3, List<BuildingFunctionalPoint>> functionalPoints = settings.getFunctionalPoints();
                if (building.getRegion().getBlocks().size() == 1) {
                    list = (List<BuildingFunctionalPoint>)CollectionsKt.first((Iterable)functionalPoints.values());
                } else {
                    list = functionalPoints.get(locVector);
                    if (list == null) {
                        return null;
                    }
                }
                List<BuildingFunctionalPoint> points = list;
                Iterable iterable = points;
                for (Object t : iterable) {
                    BuildingFunctionalPoint x = (BuildingFunctionalPoint)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)x.getType(), (Object)type)) continue;
                    v4 = t;
                    break block7;
                }
                v4 = null;
            }
            return v4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/constants/land/building/info/BuildingSettings$Validation;", "", "type", "Lorg/kingdoms/constants/land/building/info/BuildingSettings$ValidationType;", "message", "Lorg/kingdoms/locale/messenger/Messenger;", "material", "Lorg/kingdoms/libs/xseries/XMaterial;", "color", "Ljava/awt/Color;", "settings", "Lorg/kingdoms/utils/config/ConfigSection;", "<init>", "(Lorg/kingdoms/constants/land/building/info/BuildingSettings$ValidationType;Lorg/kingdoms/locale/messenger/Messenger;Lcom/cryptomorin/xseries/XMaterial;Ljava/awt/Color;Lorg/kingdoms/utils/config/ConfigSection;)V", "getType", "()Lorg/kingdoms/constants/land/building/info/BuildingSettings$ValidationType;", "getMessage", "()Lorg/kingdoms/locale/messenger/Messenger;", "getMaterial", "()Lcom/cryptomorin/xseries/XMaterial;", "getColor", "()Ljava/awt/Color;", "getSettings", "()Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static class Validation {
        @NotNull
        private final ValidationType type;
        @Nullable
        private final Messenger message;
        @Nullable
        private final XMaterial material;
        @Nullable
        private final Color color;
        @NotNull
        private final ConfigSection settings;

        public Validation(@NotNull ValidationType type, @Nullable Messenger message, @Nullable XMaterial material, @Nullable Color color, @NotNull ConfigSection settings) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.type = type;
            this.message = message;
            this.material = material;
            this.color = color;
            this.settings = settings;
        }

        @NotNull
        public final ValidationType getType() {
            return this.type;
        }

        @Nullable
        public final Messenger getMessage() {
            return this.message;
        }

        @Nullable
        public final XMaterial getMaterial() {
            return this.material;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        @NotNull
        public final ConfigSection getSettings() {
            return this.settings;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/constants/land/building/info/BuildingSettings$ValidationType;", "", "<init>", "(Ljava/lang/String;I)V", "INFO", "WARNING", "ERROR", "core"})
    public static final class ValidationType
    extends Enum<ValidationType> {
        public static final /* enum */ ValidationType INFO = new ValidationType();
        public static final /* enum */ ValidationType WARNING = new ValidationType();
        public static final /* enum */ ValidationType ERROR = new ValidationType();
        private static final /* synthetic */ ValidationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ValidationType[] values() {
            return (ValidationType[])$VALUES.clone();
        }

        public static ValidationType valueOf(String value) {
            return Enum.valueOf(ValidationType.class, value);
        }

        @NotNull
        public static EnumEntries<ValidationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = validationTypeArray = new ValidationType[]{ValidationType.INFO, ValidationType.WARNING, ValidationType.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

