/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building;

import java.time.Duration;
import java.util.Map;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstructionListener;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.info.BuildingConstructionValidation;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0003H&J\b\u0010\t\u001a\u00020\u0003H&J\b\u0010\n\u001a\u00020\u0003H&J\b\u0010\u000b\u001a\u00020\u0003H&J\b\u0010\f\u001a\u00020\u0003H&J\b\u0010\r\u001a\u00020\u0003H&J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H'J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H'J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH&J\b\u0010\u001d\u001a\u00020\u0001H&J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH&J\u0016\u0010\"\u001a\u00020\u00032\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006&\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/constants/land/building/BuildingConstruction;", "Lorg/kingdoms/constants/land/building/Building;", "prepare", "", "settings", "Lorg/kingdoms/constants/land/building/info/BuildingSettings;", "isLoaded", "", "continueLastState", "unload", "start", "resume", "finishInstantly", "pause", "getType", "Lorg/kingdoms/constants/land/building/BuildingConstructionType;", "getState", "Lorg/kingdoms/constants/land/building/BuildingConstructionState;", "addListener", "listener", "Lorg/kingdoms/constants/land/building/BuildingConstructionListener;", "onChunkLoad", "chunk", "Lorg/kingdoms/server/location/BlockVector2;", "onChunkUnload", "getTimePassed", "Ljava/time/Duration;", "getTimeRemaining", "getDuration", "asFinishedBuilding", "validateBlocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "Lorg/kingdoms/constants/land/building/info/BuildingConstructionValidation;", "serialize", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
@SourceDebugExtension(value={"SMAP\nBuildingConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingConstruction.kt\norg/kingdoms/constants/land/building/BuildingConstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public interface BuildingConstruction
extends Building {
    @ApiStatus.OverrideOnly
    public void prepare(@NotNull BuildingSettings var1);

    public boolean isLoaded();

    public void continueLastState();

    public void unload();

    public void start();

    public void resume();

    public void finishInstantly();

    public void pause();

    @NotNull
    public BuildingConstructionType getType();

    @NotNull
    public BuildingConstructionState getState();

    public void addListener(@NotNull BuildingConstructionListener var1);

    @ApiStatus.OverrideOnly
    public boolean onChunkLoad(@NotNull BlockVector2 var1);

    @ApiStatus.OverrideOnly
    public boolean onChunkUnload(@NotNull BlockVector2 var1);

    @NotNull
    public Duration getTimePassed();

    @NotNull
    default public Duration getTimeRemaining() {
        Duration duration;
        Duration duration2 = this.getDuration();
        if (duration2.isZero()) {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            return duration3;
        }
        Duration remaining = duration2.minus(this.getTimePassed());
        if (remaining.isNegative()) {
            Duration duration4 = Duration.ZERO;
            duration = duration4;
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ZERO");
        } else {
            Intrinsics.checkNotNull((Object)remaining);
            duration = remaining;
        }
        return duration;
    }

    @NotNull
    public Duration getDuration();

    @NotNull
    public Building asFinishedBuilding();

    @NotNull
    public Map<BlockVector3, BuildingConstructionValidation> validateBlocks();

    @Override
    default public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Building.super.serialize(context);
        SectionableDataSetter $this$serialize_u24lambda_u241 = sectionableDataSetter = context.getDataProvider();
        boolean bl = false;
        BuildingConstructionState state = this.getState();
        if (!(state != BuildingConstructionState.CANCELLED)) {
            boolean bl2 = false;
            String string = "CANCELLED appeared while serializing " + $this$serialize_u24lambda_u241;
            throw new IllegalArgumentException(string.toString());
        }
        $this$serialize_u24lambda_u241.setString("type", this.getType().name());
        $this$serialize_u24lambda_u241.setString("state", state.name());
        $this$serialize_u24lambda_u241.setLong("timePassed", this.getTimePassed().toMillis());
    }
}

