/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction.gui;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.kingdoms.constants.economy.DualCost;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.GUIProtectionInterrupter;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockContext;
import org.kingdoms.utils.internal.functional.Fn;

public class KingdomItemGUIContext<T extends KingdomBuilding<?>> {
    private final KingdomItemInteractEvent<T> event;
    private InteractiveGUI refresher;

    public KingdomItemGUIContext(KingdomItemInteractEvent<T> event) {
        this.event = event;
    }

    public boolean isRefreshing() {
        return this.refresher != null;
    }

    public KingdomItemGUIContext<T> refresh(InteractiveGUI gui) {
        this.refresher = gui;
        return this;
    }

    public KingdomItemInteractEvent<T> getEvent() {
        return this.event;
    }

    public void pushRenamingGUI(Structure structure, InteractiveGUI gui) {
        @Nullable Player player = this.event.getPlayer().getPlayer();
        gui.push("rename", () -> {
            KingdomsLang.STRUCTURES_ENTER_NAME.sendMessage((CommandSender)player);
            gui.startConversation("rename");
        }, input -> {
            input = MessageHandler.colorize(input);
            gui.endConversation();
            KingdomsLang.STRUCTURES_NAME_SET.sendMessage((CommandSender)player, "name", input);
            structure.setName((String)input);
            structure.getVisualsManager().updateVisuals();
        }, new Object[0]);
    }

    public static void addOtherButtons(KingdomItemInteractEvent<?> event, InteractiveGUI gui) {
        KingdomPlayer kp = event.getPlayer();
        Player player = kp.getPlayer();
        KingdomBuilding building = (KingdomBuilding)event.getKingdomBlock();
        Land land = ((KingdomBuilding)event.getKingdomBlock()).getLand();
        Kingdom kingdom = Objects.requireNonNull(land.getKingdom(), () -> "Building land doesn't belong to any kingdom: " + building);
        DualCost repairCost = ((KingdomBuildingStyle)building.getStyle()).getRepairCost(building, kingdom);
        gui.getMessageContext().raw("repair_cost_rp", repairCost.getResourcePoints()).raw("repair_cost_money", repairCost.getMoney());
        gui.push("repair", () -> {
            MessagePlaceholderProvider context = building.getMessageContext();
            double durability = building.getDurability();
            if (durability >= 0.0) {
                KingdomsLang.BUILDING_REPAIRS_DOESNT_NEED.sendError((CommandSender)player, context);
                return;
            }
            if (!kingdom.getResourcePoints().has(repairCost.getResourcePoints()) || !kingdom.getBank().has(repairCost.getMoney())) {
                context.raw("rp", repairCost.getResourcePoints());
                context.raw("money", repairCost.getMoney());
                KingdomsLang.BUILDING_REPAIRS_INSUFFICIENT_FUNDS.sendError((CommandSender)player, context);
                return;
            }
            KingdomsLang.BUILDING_REPAIRS_STARTED.sendMessage((CommandSender)player, context);
            kingdom.getResourcePoints().subtract(repairCost.getResourcePoints());
            kingdom.getBank().subtract(repairCost.getMoney());
            building.repair();
        }, new Object[0]);
        gui.push("break", () -> {
            KingdomsBlockBreakContext<KingdomBuilding> ctx = new KingdomsBlockBreakContext<KingdomBuilding>(new BlockBreakEvent(((KingdomBuilding)event.getKingdomBlock()).getBlock(), player), (KingdomBuilding)event.getKingdomBlock(), kp);
            ctx.getMetadata().put(KingdomsBlockContext.DefaultMetadatas.CONFIRMATION, (Object)true);
            Messenger error = ((KingdomBuilding)event.getKingdomBlock()).getKingdomBlockHandler().onBreak((KingdomsBlockBreakContext)Fn.cast(ctx));
            if (error != null) {
                gui.close();
                error.sendError((CommandSender)player, new Object[0]);
            } else {
                ctx.finalizeProcess();
            }
        }, new Object[0]);
    }

    public static void putGUI(InteractiveGUI gui, KingdomBuilding<?> building, KingdomItemInteractEvent<?> event) {
        SimpleLocation loc = ((KingdomBuilding)event.getKingdomItem()).getOrigin();
        Player player = event.getPlayer().getPlayer();
        gui.eavesdrop((a, b) -> GUIProtectionInterrupter.handleConversation(building, gui.getOwner()));
        GUIProtectionInterrupter.OPENED_GUI_PLAYER.put(player, loc);
        GUIProtectionInterrupter.OPENED_GUI.compute(loc, (k, list) -> {
            if (list == null) {
                list = new CopyOnWriteArrayList<Player>();
            }
            list.add(player);
            return list;
        });
    }

    public void closeForOthers() {
        KingdomItemGUIContext.closeForOthers((KingdomBuilding)this.event.getKingdomItem(), this.event.getPlayer().getPlayer().getUniqueId());
    }

    public static void closeForOthers(KingdomBuilding<?> building, UUID ignoring) {
        GUIProtectionInterrupter.cancelAllConversations(building, null);
        List viewers = GUIProtectionInterrupter.OPENED_GUI.get(building.getOrigin());
        if (viewers != null) {
            for (Player viewer : viewers) {
                if (viewer.getUniqueId().equals(ignoring)) continue;
                viewer.closeInventory();
            }
        }
    }

    public InteractiveGUI finalizeGUI(InteractiveGUI gui) {
        return this.finalizeGUI(gui, false);
    }

    public InteractiveGUI finalizeGUI(InteractiveGUI gui, boolean refresh) {
        if (gui == null) {
            return null;
        }
        KingdomBuilding building = (KingdomBuilding)this.event.getKingdomItem();
        if (!refresh) {
            KingdomItemGUIContext.putGUI(gui, building, this.event);
        }
        KingdomItemGUIContext.addOtherButtons(this.event, gui);
        if (building instanceof Structure) {
            this.pushRenamingGUI((Structure)building, gui);
        }
        if (refresh) {
            gui.setRemainingOptions();
            gui.getOwner().updateInventory();
        } else {
            gui.open();
        }
        return gui;
    }
}

