/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import java.util.Locale;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

public abstract class KingdomBuildingType<B extends KingdomBuilding<S>, S extends KingdomBuildingStyle<B, S, T>, T extends KingdomBuildingType<B, S, T>> {
    protected final String name;

    public KingdomBuildingType(String name) {
        this.name = name;
    }

    public static Pair<KingdomBuildingStyle<?, ?, ?>, Integer> getTypeOf(ItemStack item) {
        NBTTagCompound nbt = ItemNBT.getTag(item);
        if ((nbt = nbt.tryGetTag("Kingdoms", NBTTagType.COMPOUND)) != null) {
            String tag = (String)nbt.get("Structure", NBTTagType.STRING);
            if (tag != null) {
                return Pair.of(StructureRegistry.get().getStyle(tag), (Integer)nbt.get("Level", NBTTagType.INT));
            }
            tag = (String)nbt.get("Turret", NBTTagType.STRING);
            if (tag != null) {
                return Pair.of(TurretRegistry.get().getStyle(tag), (Integer)nbt.get("Level", NBTTagType.INT));
            }
        }
        return null;
    }

    public abstract String getCategoryName();

    public Messenger getLang(String ... path) {
        String type = this.getCategoryName().toLowerCase(Locale.ENGLISH);
        return new LanguageEntryMessenger(ArrayUtils.merge(new String[]{type}, path)).safe();
    }

    public boolean canBePlacedInUnclaimed() {
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return super.toString() + '{' + this.name + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KingdomBuildingType)) {
            return false;
        }
        KingdomBuildingType type = (KingdomBuildingType)obj;
        return this.name.equals(type.name);
    }

    public String getName() {
        return this.name;
    }

    public abstract InteractiveGUI open(KingdomItemGUIContext<B> var1);

    public abstract B build(KingdomItemBuilder<B, S, T> var1);
}

