/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.Item;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.constants.economy.DualCost;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.Upgrade;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.schema.BuildingSchema;
import org.kingdoms.constants.land.building.schema.EvaluatedBuildingMapping;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XBiome;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.UnsafeLocations;
import org.kingdoms.utils.UnsafeSimpleChunkLocation;
import org.kingdoms.utils.UnsafeSimpleLocation;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.string.Strings;

public abstract class KingdomBuildingStyle<B extends KingdomBuilding<S>, S extends KingdomBuildingStyle<B, S, T>, T extends KingdomBuildingType<B, S, T>>
implements Upgrade,
CascadingMessageContextProvider {
    protected final String name;
    protected final T type;

    public KingdomBuildingStyle(String name, T type) {
        this.name = name;
        this.type = type;
    }

    public abstract KeyedConfigAccessor getOption(String ... var1);

    private static SimpleLocation createFakeLocation(Kingdom kingdom) {
        Land land = new Land(UnsafeLocations.UNSAFE_CHUNK_LOCATION, null, null, System.currentTimeMillis());
        land.setKingdom(kingdom.getId());
        return new UnsafeSimpleLocation(new UnsafeSimpleChunkLocation(land));
    }

    public KingdomItem buildItem(KingdomItemCreateSettings settings) {
        KingdomItemBuilder builder = new KingdomItemBuilder(this, KingdomBuildingStyle.createFakeLocation(settings.getOwningKingdom()), settings.getRequestedBy());
        return ((KingdomBuilding)((KingdomBuildingType)this.type).build(builder)).getItem(settings);
    }

    public boolean hasItem() {
        return this.getOption("item").getSection() != null;
    }

    public T getType() {
        return this.type;
    }

    public void loadSettings() {
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.addChild("style", new MessagePlaceholderProvider().raw("displayname", this.getDisplayName()));
    }

    public Map<BlockVector3, EvaluatedBuildingMapping> matchSchema(BlockLocation3 origin, int level) {
        KeyedConfigAccessor schemaOpt = this.getOption("schema");
        if (!schemaOpt.isSet()) {
            return new HashMap<BlockVector3, EvaluatedBuildingMapping>();
        }
        ConfigAccessor schemasSection = schemaOpt.getSection().noDefault();
        int entry = KingdomsConfig.getClosestLevelSection(schemasSection, level);
        schemasSection = schemasSection.get(String.valueOf(entry)).getSection();
        ConfigSection section = schemasSection.getSection();
        BuildingSchema schema = BuildingSchema.parse(section);
        return schema.locateBlocks(origin);
    }

    private DualCost getCost(String[] name, Kingdom kingdom) {
        return this.getCost(name, new PlaceholderContextBuilder().withContext(kingdom));
    }

    private DualCost getCost(String[] name, PlaceholderContextBuilder context) {
        KeyedConfigAccessor costOpt = this.getOption(name);
        MathExpression rpCost = costOpt.getMathExpression();
        if (!rpCost.isDefault()) {
            return new DualCost(MathUtils.eval(rpCost, (PlaceholderProvider)context), 0.0);
        }
        ConfigAccessor section = costOpt.noDefault().getSection();
        if (section == null) {
            throw new IllegalStateException("No cost specified for building " + this);
        }
        rpCost = section.get("resource-points").getMathExpression();
        MathExpression moneyCost = section.get("money").getMathExpression();
        return new DualCost(MathUtils.eval(rpCost, (PlaceholderProvider)context), MathUtils.eval(moneyCost, (PlaceholderProvider)context));
    }

    public DualCost getCost(Kingdom kingdom) {
        return this.getCost(new String[]{"cost"}, kingdom);
    }

    public DualCost getRepairCost(KingdomBuilding<?> building, Kingdom kingdom) {
        return this.getCost(new String[]{"repair", "cost"}, building.getMessageContext().withContext(kingdom));
    }

    @Override
    public double getUpgradeCost(PlaceholderProvider placeholders) {
        return MathUtils.eval(this.getOption("upgrade-cost").getMathExpression(), placeholders);
    }

    @Override
    public int getMaxLevel(PlaceholderProvider placeholders) {
        return (int)MathUtils.eval(this.getOption("max-level").getMathExpression(), placeholders);
    }

    public double getMaxDurability(PlaceholderProvider placeholders) {
        MathExpression math = this.getOption("durability").get(NodeInterpreter.MATH);
        return MathUtils.eval(math, placeholders);
    }

    public MathExpression getBuildDuration(BuildingConstructionType type) {
        KeyedConfigAccessor buildDuration = this.getOption("build-duration").getSection().noDefault().get(Strings.configOption(type));
        if (!buildDuration.isSet()) {
            return MathCompiler.DEFAULT_VALUE;
        }
        return buildDuration.get(NodeInterpreter.MATH);
    }

    @Override
    public String getDataName() {
        return this.name;
    }

    @Override
    public int getDefaultLevel(PlaceholderProvider placeholders) {
        return 1;
    }

    public String getSkull(int level) {
        ConfigAccessor section = this.getOption("skull").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, level);
        return section.getString(String.valueOf(entry));
    }

    public boolean hideHolograms() {
        return this.getOption("hide-holograms").getBoolean();
    }

    public boolean canBePlacedInBiome(Location location) {
        XBiome biome;
        ConfigAccessor worldSettings = this.getOption("biomes", location.getWorld().getName()).getSection();
        if (worldSettings == null) {
            return true;
        }
        boolean whitelist = worldSettings.getBoolean("whitelist");
        List<String> biomes = worldSettings.getStringList("list");
        return whitelist == biomes.contains((biome = XBiome.of((Biome)location.getBlock().getBiome())).name());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Messenger getDisplayName() {
        return new StaticMessenger(this.getOption("name").getString());
    }

    public void droppedItemName(Item item) {
        item.setCustomName(this.getDisplayName().getMessageObject(Language.getDefault()).buildPlain(new MessagePlaceholderProvider()));
        item.setCustomNameVisible(true);
    }

    public String toString() {
        return "KingdomItemStyle:{" + this.name + '}';
    }

    public long getSellCost(int lvl, Kingdom kingdom) {
        String option = this.getOption("sell").getString();
        if (option == null) {
            return 0L;
        }
        return (long)MathUtils.evaluateEquation(option, "lvl", lvl, "cost", this.getCost(kingdom).getResourcePoints());
    }

    public Messenger evaluateConditions(PlaceholderProvider context, String type) {
        ConfigAccessor conditions = this.getOption("conditions", type).getSection();
        if (conditions == null) {
            return null;
        }
        ConditionChain<Messenger> conds = ConditionProcessor.mapConditions(conditions.getSection());
        return conds.evaluate(context, true);
    }
}

