/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.item;

import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.item.AbstractKingdomItemData;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.platform.bukkit.item.ItemNBT;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0012\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0016\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u0013R\u00020\u00050\u0013R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R<\u0010\u0017\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00180\u0018 \u0015*\u0016\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u0013R\u00020\u00050\u0013R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lorg/kingdoms/constants/item/AbstractKingdomItem;", "Lorg/kingdoms/constants/item/KingdomItem;", "item", "Lorg/bukkit/inventory/ItemStack;", "itemNBT", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "<init>", "(Lorg/bukkit/inventory/ItemStack;Lorg/kingdoms/nbt/tag/NBTTagCompound;)V", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "setItem", "(Lorg/bukkit/inventory/ItemStack;)V", "getItemNBT", "()Lorg/kingdoms/nbt/tag/NBTTagCompound;", "kingdomsNBT", "_data", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/constants/item/KingdomItemData;", "_version", "Lorg/kingdoms/nbt/tag/NBTTagCompound$PropertyRef;", "", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Lorg/kingdoms/nbt/tag/NBTTagCompound$PropertyRef;", "_dateCreated", "", "value", "version", "getVersion", "()I", "setVersion", "(I)V", "dateCreated", "getDateCreated", "()J", "setDateCreated", "(J)V", "data", "getData", "()Lorg/kingdoms/constants/namespace/NamespacedMap;", "getNBT", "applyChanges", "", "core"})
public final class AbstractKingdomItem
implements KingdomItem {
    @NotNull
    private ItemStack item;
    @NotNull
    private final NBTTagCompound itemNBT;
    @NotNull
    private final NBTTagCompound kingdomsNBT;
    @NotNull
    private final NamespacedMap<KingdomItemData> _data;
    private final NBTTagCompound.PropertyRef<Integer> _version;
    private final NBTTagCompound.PropertyRef<Long> _dateCreated;
    @NotNull
    private final NamespacedMap<KingdomItemData> data;

    public AbstractKingdomItem(@NotNull ItemStack item, @NotNull NBTTagCompound itemNBT) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)itemNBT, (String)"itemNBT");
        this.item = item;
        this.itemNBT = itemNBT;
        NBTTagCompound nBTTagCompound = this.getItemNBT().getCompound("Kingdoms");
        Intrinsics.checkNotNull((Object)nBTTagCompound);
        this.kingdomsNBT = nBTTagCompound;
        this._data = new NamespacedMap();
        this._version = this.kingdomsNBT.createReference("Version", NBTTagInt.of(2), true);
        this._dateCreated = this.kingdomsNBT.createReference("DateCreated", NBTTagLong.of(System.currentTimeMillis()), true);
        NBTTagCompound nBTTagCompound2 = this.kingdomsNBT.getCompound("Data");
        if (nBTTagCompound2 != null) {
            NBTTagCompound dataTag = nBTTagCompound2;
            boolean bl = false;
            Object object = dataTag.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
            for (Map.Entry entry : object.entrySet()) {
                Namespace ns;
                String key = (String)entry.getKey();
                NBTTag data = (NBTTag)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)Namespace.fromString(key), (String)"fromString(...)");
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagCompound");
                NBTTagCompound compound = (NBTTagCompound)data;
                ((Map)this._data).put(ns, new AbstractKingdomItemData(ns, compound));
            }
        }
        this.data = this._data;
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.item = itemStack;
    }

    @Override
    @NotNull
    public NBTTagCompound getItemNBT() {
        return this.itemNBT;
    }

    @Override
    public int getVersion() {
        Integer n = this._version.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void setVersion(int value) {
        this._version.set(value);
    }

    @Override
    public long getDateCreated() {
        Long l = this._dateCreated.get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"get(...)");
        return ((Number)l).longValue();
    }

    @Override
    public void setDateCreated(long value) {
        this._dateCreated.set(value);
    }

    @Override
    @NotNull
    public NamespacedMap<KingdomItemData> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public NBTTagCompound getNBT() {
        return this.kingdomsNBT;
    }

    @Override
    public void applyChanges() {
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound dataNBT = nBTTagCompound;
        for (Map.Entry entry : ((Map)this._data).entrySet()) {
            Namespace ns = (Namespace)entry.getKey();
            KingdomItemData datum = (KingdomItemData)entry.getValue();
            dataNBT.set(ns.asNormalizedString(), (NBTTag)datum.getNBT());
        }
        this.kingdomsNBT.set("Data", (NBTTag)dataNBT);
        this.setItem(ItemNBT.setTag(this.getItem(), this.getItemNBT()));
    }
}

