/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion.abilities;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.group.upgradable.champion.StandardChampionUpgrade;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.invasions.Invasion;

public class ChampionAbilityThor
extends ChampionAbility
implements Listener {
    private static final String THOR = "THOR";

    public ChampionAbilityThor() {
        super(StandardChampionUpgrade.THOR, true);
    }

    @Override
    public boolean trigger(Invasion invasion) {
        if (this.callEvent(invasion)) {
            return false;
        }
        this.cooldown(invasion, this.getOption("cooldown").getTime(this.getEdits(invasion)));
        Player player = invasion.getInvaderPlayer();
        LightningStrike strike = player.getWorld().strikeLightning(player.getLocation());
        strike.setMetadata(THOR, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)invasion));
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            if (event.getDamager().hasMetadata(THOR)) {
                event.setCancelled(true);
            }
            return;
        }
        List meta = event.getDamager().getMetadata(THOR);
        if (meta.isEmpty()) {
            return;
        }
        Invasion invasion = (Invasion)((MetadataValue)meta.get(0)).value();
        Player player = (Player)event.getEntity();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom() && invasion.getDefender().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) {
            event.setCancelled(true);
        } else {
            event.setDamage(event.getDamage() + this.getScaling(invasion));
        }
    }
}

