/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion.abilities;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.group.upgradable.champion.StandardChampionUpgrade;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomChampionAbilityEntity;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.internal.reflection.Reflect;

public class ChampionAbilityFangs
extends ChampionAbility
implements Listener {
    private static final boolean SUPPORTS_FANGS = Reflect.classExists("org.bukkit.entity.EvokerFangs");

    public ChampionAbilityFangs() {
        super(StandardChampionUpgrade.FANGS, true);
    }

    @Override
    public boolean trigger(Invasion invasion) {
        if (this.callEvent(invasion)) {
            return false;
        }
        this.cooldown(invasion, this.getOption("cooldown").getTime(this.getEdits(invasion)));
        Creature champion = invasion.getChampion();
        ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.DRAGON_BREATH).withCount(20).offset(1.0);
        double radius = this.getScaling("radius", invasion);
        for (Entity entity2 : champion.getNearbyEntities(radius, radius, radius)) {
            Entity spawned;
            if (!(entity2 instanceof Player)) continue;
            Player player = (Player)entity2;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (invasion.getDefender().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) continue;
            Location loc = entity2.getLocation();
            if (SUPPORTS_FANGS) {
                EvokerFangs fangs = (EvokerFangs)champion.getWorld().spawnEntity(loc, EntityType.EVOKER_FANGS);
                fangs.setOwner((LivingEntity)champion);
                spawned = fangs;
            } else {
                spawned = champion.getWorld().spawnEntity(loc, XEntityType.FIREWORK_ROCKET.get());
            }
            display.spawn(loc);
            KingdomChampionAbilityEntity kEntity = new KingdomChampionAbilityEntity(spawned, invasion);
            KingdomEntityRegistry.add(kEntity);
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!SUPPORTS_FANGS) {
            return;
        }
        if (!(event.getDamager() instanceof EvokerFangs)) {
            return;
        }
        EvokerFangs fangs = (EvokerFangs)event.getDamager();
        if (fangs.getOwner() == null) {
            return;
        }
        Invasion invasion = Invasion.getInvasion(fangs.getOwner());
        if (invasion == null) {
            return;
        }
        double damage = this.getScaling(invasion);
        event.setDamage(damage);
    }
}

