/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion.abilities;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.group.upgradable.champion.StandardChampionUpgrade;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.pets.PetInfo;
import org.kingdoms.utils.LocationUtils;

public class ChampionAbilityBurst
extends ChampionAbility {
    public ChampionAbilityBurst() {
        super(StandardChampionUpgrade.BURST, true);
    }

    @Override
    public boolean trigger(Invasion invasion) {
        if (this.callEvent(invasion)) {
            return false;
        }
        Creature champion = invasion.getChampion();
        int minTargets = (int)this.getScaling("min-targets", invasion);
        double range = this.getScaling("range", invasion);
        List entities = champion.getNearbyEntities(range, range, range);
        if (entities.size() < minTargets) {
            return false;
        }
        List hostileEntities = entities.stream().filter(entity2 -> entity2 instanceof LivingEntity).filter(entity2 -> {
            Kingdom attackerKingdom = null;
            if (entity2 instanceof Player) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(entity2.getUniqueId());
                attackerKingdom = kp.getKingdom();
            } else {
                PetInfo pet = ServiceHandler.getPetInfo(entity2);
                if (pet != null && pet.canBeAttacked()) {
                    KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(pet.getOwner());
                    attackerKingdom = kp.getKingdom();
                }
            }
            return attackerKingdom == null || invasion.getDefender().hasAttribute(attackerKingdom, (RelationAttribute)StandardRelationAttribute.CEASEFIRE);
        }).collect(Collectors.toList());
        if (hostileEntities.size() < minTargets) {
            return false;
        }
        double damage = this.getScaling("damage", invasion);
        double kb = this.getScaling("knockback", invasion);
        Particles.sphere((double)3.0, (double)50.0, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.FLAME).withLocation(champion.getEyeLocation()));
        for (Entity hostileEntity : hostileEntities) {
            LivingEntity living = (LivingEntity)hostileEntity;
            living.damage(damage, (Entity)champion);
            LocationUtils.knockback(champion.getLocation().toVector(), (Entity)living, kb, 0.5);
        }
        return true;
    }
}

