/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.string.Strings;

public interface StandardKingdomUpgrade
extends KingdomUpgrade {
    public EnumConfig getEnabledOption();

    public EnumConfig getScalingOption();

    public EnumConfig getUpgradeCostOption();

    public EnumConfig getMaxLevelOption();

    public EnumConfig getDefaultLevelOption();

    public ConfigAccessor getConfig();

    @Override
    default public double getScaling(PlaceholderProvider placeholderProvider) {
        return this.eval(this.getScalingOption(), placeholderProvider);
    }

    default public double eval(EnumConfig config, PlaceholderProvider placeholderProvider) {
        MathExpression expr = config.getManager().withOption("upgrade", Strings.configOption(this.getDataName())).getMathExpression();
        return MathUtils.eval(expr, placeholderProvider);
    }

    @Override
    default public boolean isEnabled(PlaceholderProvider placeholderProvider) {
        KeyedYamlConfigAccessor opt = this.getEnabledOption().getManager().withOption("upgrade", Strings.configOption(this.getDataName()));
        return !opt.isSet() || opt.getBoolean();
    }

    default public boolean isEnabled() {
        return this.isEnabled(null);
    }

    @Override
    default public double getUpgradeCost(PlaceholderProvider placeholders) {
        return this.eval(this.getUpgradeCostOption(), placeholders);
    }

    @Override
    default public int getMaxLevel(PlaceholderProvider placeholders) {
        return (int)this.eval(this.getMaxLevelOption(), placeholders);
    }

    @Override
    public String getDataName();

    @Override
    default public int getDefaultLevel(PlaceholderProvider placeholders) {
        return this.getDefaultLevelOption() == null ? 0 : (int)this.eval(this.getDefaultLevelOption(), placeholders);
    }

    default public Messenger evaluateConditions(MessagePlaceholderProvider settings) {
        ConfigAccessor conditions = this.getConfig().noDefault().get("conditions").getSection();
        if (conditions == null) {
            return null;
        }
        ConditionChain<Messenger> conds = ConditionProcessor.mapConditions(conditions.getSection());
        return conds.evaluate(settings, true);
    }
}

