/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import java.util.Collection;
import java.util.UUID;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.upgradable.StandardKingdomUpgrade;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.Masswar;
import org.kingdoms.utils.commands.CommandConditionMixin;
import org.kingdoms.utils.commands.ConfigCommandExecuter;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.Strings;

public class MiscUpgrade
implements StandardKingdomUpgrade {
    private static final NamespacedRegistry<MiscUpgrade> REGISTRY = new NamespacedRegistry();
    private final Namespace namespace;
    private final boolean canBeDisabled;
    public static final MiscUpgrade ANTI_EXPLOSION = MiscUpgrade.register("ANTI_EXPLOSION");
    public static final MiscUpgrade ANTI_TRAMPLE = MiscUpgrade.register("ANTI_TRAMPLE");
    public static final MiscUpgrade NEXUS_GUARDS = MiscUpgrade.register("NEXUS_GUARDS");
    public static final MiscUpgrade GUARDS = MiscUpgrade.register("GUARDS");
    public static final MiscUpgrade INSANITY = MiscUpgrade.register("INSANITY");
    public static final MiscUpgrade GLORY = MiscUpgrade.register("GLORY");
    public static final MiscUpgrade CHEST_SIZE = MiscUpgrade.register("CHEST_SIZE", false);
    public static final MiscUpgrade MAX_MEMBERS = MiscUpgrade.register("MAX_MEMBERS", false);
    public static final MiscUpgrade MAX_TURRETS = MiscUpgrade.register("MAX_TURRETS", false);
    public static final MiscUpgrade MAX_CLAIMS = MiscUpgrade.register("MAX_CLAIMS", false);
    public static final MiscUpgrade FLIGHT = MiscUpgrade.register("FLIGHT", true);
    public static final MiscUpgrade KEEP_INVENTORY = MiscUpgrade.register("KEEP_INVENTORY", true);
    public static final MiscUpgrade INVASION_TELEPORTATION = MiscUpgrade.register("INVASION_TELEPORTATION");
    public static final MiscUpgrade INVASIONS = MiscUpgrade.register("INVASIONS", false);

    public MiscUpgrade(Namespace namespace, boolean canBeDisabled) {
        this.namespace = namespace;
        this.canBeDisabled = canBeDisabled;
    }

    public static void registerAll() {
        ConfigSection config = KingdomsConfig.MISC_UPGRADE.getConfig();
        for (String key : config.getKeys()) {
            ConfigSection upgrade = config.getSection(key);
            if (!Namespace.isValidKey(key = Strings.configOptionToEnum(key))) continue;
            MiscUpgrade.register(Namespace.fromConfigString(key).getKey(), upgrade.getBoolean("can-be-disabled"));
        }
    }

    private static MiscUpgrade register(String name) {
        return MiscUpgrade.register(name, true);
    }

    private static MiscUpgrade register(String name, boolean canBeDisabled) {
        MiscUpgrade upgrade;
        Namespace ns = Namespace.kingdoms(name);
        if (!REGISTRY.isRegisetered(ns)) {
            upgrade = new MiscUpgrade(ns, canBeDisabled);
            REGISTRY.register(upgrade);
        } else {
            upgrade = REGISTRY.getRegistered((MiscUpgrade)((Object)ns));
        }
        return upgrade;
    }

    public static NamespacedRegistry<MiscUpgrade> getRegistry() {
        return REGISTRY;
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    @Override
    public String getDataName() {
        return this.namespace.asNormalizedString();
    }

    public String toString() {
        return this.namespace.toString();
    }

    @Override
    public boolean isEnabled(PlaceholderProvider placeholderProvider) {
        if (Masswar.getInstance().isRunning() && KingdomsConfig.Invasions.MASSWAR_DISABLE_MISC_UPGRADES.getManager().getStringList().contains(this.namespace.getConfigOptionName())) {
            return false;
        }
        return StandardKingdomUpgrade.super.isEnabled(placeholderProvider);
    }

    public void executeCommands(MessagePlaceholderProvider settings, int level) {
        YamlConfigAccessor config = KingdomsConfig.MiscUpgrades.COMMANDS.getManager().noDefault().withOption("upgrade", Strings.configOption(this.getDataName())).getSection();
        if (config == null) {
            return;
        }
        int closest = KingdomsConfig.getClosestLevelSection(config, level);
        ConfigSection section = config.getSection().getSection(Integer.toString(closest));
        CommandConditionMixin.parse(section).execute(new ConfigCommandExecuter(null, settings, true));
    }

    public void performPermissionOperations(MessagePlaceholderProvider settings, int level) {
        YamlConfigAccessor config = KingdomsConfig.MiscUpgrades.PERMISSIONS.getManager().noDefault().withOption("upgrade", Strings.configOption(this.getDataName())).getSection();
        if (config == null) {
            return;
        }
        int closest = KingdomsConfig.getClosestLevelSection(config, level);
        ConfigSection section = config.getSection().getSection(Integer.toString(closest));
        CommandConditionMixin.parse(section).execute(new ConfigCommandExecuter(null, settings, true));
    }

    public void removeAllPermissions(Collection<UUID> players) {
        YamlConfigAccessor config = KingdomsConfig.MiscUpgrades.PERMISSIONS.getManager().noDefault().withOption("upgrade", Strings.configOption(this.getDataName())).getSection();
        if (config == null) {
            return;
        }
        ConditionChain.removeAllPermissions(players, config.getSection());
    }

    public void addAllPermissions(Collection<UUID> players) {
        YamlConfigAccessor config = KingdomsConfig.MiscUpgrades.PERMISSIONS.getManager().noDefault().withOption("upgrade", Strings.configOption(this.getDataName())).getSection();
        if (config == null) {
            return;
        }
        ConditionChain.removeAllPermissions(players, config.getSection());
    }

    @Override
    public ConfigAccessor getConfig() {
        YamlConfigAccessor accessor = new YamlConfigAccessor(KingdomsConfig.MISC_UPGRADE.getConfig(), KingdomsConfig.MISC_UPGRADE.getDefaults());
        return accessor.get(this.namespace.getConfigOptionName()).getSection();
    }

    @Override
    public EnumConfig getEnabledOption() {
        return KingdomsConfig.MiscUpgrades.ENABLED;
    }

    @Override
    public EnumConfig getScalingOption() {
        return KingdomsConfig.MiscUpgrades.SCALING;
    }

    @Override
    public EnumConfig getUpgradeCostOption() {
        return KingdomsConfig.MiscUpgrades.COST;
    }

    @Override
    public EnumConfig getMaxLevelOption() {
        return KingdomsConfig.MiscUpgrades.MAX_LEVEL;
    }

    @Override
    public EnumConfig getDefaultLevelOption() {
        return KingdomsConfig.MiscUpgrades.DEFAULT_LEVEL;
    }

    @Override
    public Messenger getDisplayName() {
        return new DefaultedMessenger(new LanguageEntryMessenger("upgrades", "misc", this.namespace.getConfigOptionName(), "name"), () -> new StaticMessenger(Strings.capitalize(this.namespace.getKey())));
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    static {
        MiscUpgrade.registerAll();
    }
}

