/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.Upgrade;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;

public interface KingdomUpgrade
extends Upgrade,
Namespaced {
    public double getScaling(PlaceholderProvider var1);

    public static <T extends KingdomUpgrade> NamespacedMap<Integer> getDefaults(Collection<T> values) {
        NamespacedMap<Integer> upgrades = new NamespacedMap<Integer>(new HashMap(values.size()));
        for (KingdomUpgrade upgrade : values) {
            int defLvl = upgrade.getDefaultLevel(PlaceholderProvider.EMPTY);
            if (defLvl <= 0) continue;
            upgrades.put(upgrade.getNamespace(), (Integer)defLvl);
        }
        return upgrades;
    }

    public boolean isEnabled(PlaceholderProvider var1);

    default public double getScaling(Kingdom kingdom) {
        Objects.requireNonNull(kingdom, "Kingdom is null");
        int lvl = kingdom.getUpgradeLevel(this);
        if (lvl < 0) {
            lvl = 0;
        }
        return this.getScaling(new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl));
    }
}

