/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases.kingdomitem;

import com.google.common.base.Enums;
import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.LocationUtils;

public class LogTurretPurchaseAmmo
extends LogResourcePoints {
    private TurretAmmoFillEvent.FillType fillType;
    private SimpleLocation location;
    private String style;
    private int oldAmount;
    private int newAmount;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_TURRET_PURCHASE_AMMO");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogTurretPurchaseAmmo();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    protected LogTurretPurchaseAmmo() {
    }

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.fillType = (TurretAmmoFillEvent.FillType)((Object)Enums.getIfPresent(TurretAmmoFillEvent.FillType.class, (String)json.get("fillType").asString()).get());
        this.style = json.get("style").asString();
        this.location = json.get("location").asSimpleLocation();
        this.oldAmount = json.get("oldAmount").asInt();
        this.newAmount = json.get("newAmount").asInt();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setString("fillType", this.fillType.name());
        json.setString("style", this.style);
        json.get("location").setSimpleLocation(this.location);
        json.setInt("oldAmount", this.oldAmount);
        json.setInt("newAmount", this.newAmount);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.inheritPlaceholders(LocationUtils.getLocationEdits(this.location, ""));
        builder.raw("style", TurretRegistry.get().getStyle(this.style).getDisplayName());
        builder.raw("old_amount", this.oldAmount);
        builder.raw("new_amount", this.newAmount);
    }

    public LogTurretPurchaseAmmo(double resourcePoints, UUID player, TurretAmmoFillEvent.FillType fillType, SimpleLocation location, TurretStyle style, int oldAmount, int newAmount) {
        super(resourcePoints, player);
        this.fillType = fillType;
        this.location = location;
        this.style = style.getName();
        this.oldAmount = oldAmount;
        this.newAmount = newAmount;
    }
}

