/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases.kingdomitem;

import java.util.Objects;
import java.util.UUID;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public abstract class LogKingdomItemPurchase
extends LogResourcePoints {
    private KingdomBuildingStyle<?, ?, ?> style;
    private String styleName;
    private int amount;

    public LogKingdomItemPurchase() {
    }

    public LogKingdomItemPurchase(double resourcePoints, UUID player, KingdomBuildingStyle<?, ?, ?> style, int amount) {
        super(resourcePoints, player);
        this.style = Objects.requireNonNull(style);
        this.styleName = style.getName();
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.amount = json.get("amount").asInt();
        this.styleName = json.get("style").asString();
        this.style = this.getStyleFromString(this.styleName);
    }

    public KingdomBuildingStyle<?, ?, ?> getStyle() {
        return this.style;
    }

    protected abstract KingdomBuildingStyle<?, ?, ?> getStyleFromString(String var1);

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setInt("amount", this.amount);
        json.setString("style", this.style == null ? this.styleName : this.style.getName());
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.raw("amount", this.amount);
        builder.raw("item_style_display_name", this.style == null ? this.styleName : this.style.getDisplayName());
    }
}

