/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.LocationUtils;

public class LogWarppadTeleport
extends AuditLog {
    private UUID player;
    private SimpleLocation fromLocation;
    private SimpleLocation toLocation;
    private Location preciseLocation;
    private double fuelCost;
    private static final Namespace NS = Namespace.kingdoms("WARPPAD_TELEPORT");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogWarppadTeleport();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    protected LogWarppadTeleport() {
    }

    public LogWarppadTeleport(UUID player, SimpleLocation fromLocation, SimpleLocation toLocation, Location preciseLocation, double fuelCost) {
        this.player = player;
        this.fromLocation = fromLocation;
        this.toLocation = toLocation;
        this.preciseLocation = preciseLocation;
        this.fuelCost = fuelCost;
    }

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.player = json.get("player").asUUID();
        this.fromLocation = json.get("fromLocation").asSimpleLocation();
        this.toLocation = json.get("toLocation").asSimpleLocation();
        this.preciseLocation = json.get("preciseLocation").asLocation();
        this.fuelCost = json.get("fuelCost").asDouble();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("player", this.player);
        json.get("fromLocation").setSimpleLocation(this.fromLocation);
        json.get("toLocation").setSimpleLocation(this.toLocation);
        json.get("preciseLocation").setLocation(this.preciseLocation);
        json.setDouble("fuelCost", this.fuelCost);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.withContext(Bukkit.getOfflinePlayer((UUID)this.player));
        builder.raw("from_location", LocationUtils.parseLocation(this.fromLocation));
        builder.raw("to_location", LocationUtils.parseLocation(this.toLocation));
        builder.raw("precise_location", LocationUtils.parseLocation(this.preciseLocation));
        builder.raw("fuel_cost", this.fuelCost);
    }
}

