/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.LocationUtils;

public class LogExtractorCollect
extends LogResourcePoints {
    private SimpleLocation location;
    private static final Namespace NS = Namespace.kingdoms("EXTRACTOR_COLLECT");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogExtractorCollect();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    protected LogExtractorCollect() {
    }

    public LogExtractorCollect(double resourcePoints, UUID player, SimpleLocation location) {
        super(resourcePoints, player);
        this.location = location;
    }

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.location = json.get("location").asSimpleLocation();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.get("location").setSimpleLocation(this.location);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.raw("location", LocationUtils.parseLocation(this.location));
    }
}

