/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.nations;

import java.util.UUID;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public abstract class LogKingdomNation
extends AuditLog {
    private UUID nation;

    public LogKingdomNation() {
    }

    public LogKingdomNation(UUID nation) {
        this.nation = nation;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.nation = json.get("nation").asUUID();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("nation", this.nation);
    }

    public UUID getNationId() {
        return this.nation;
    }

    public Nation getNation() {
        return Nation.getNation(this.nation);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.withContext(this.getNation());
    }
}

