/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.renames;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public abstract class LogKingdomChangeString
extends LogPlayerOperator {
    private String old;
    private String newString;

    protected LogKingdomChangeString() {
    }

    public LogKingdomChangeString(UUID player, String oldName, String newName) {
        super(player);
        this.old = oldName;
        this.newString = newName;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.old = json.getString("old");
        this.newString = json.getString("new");
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setString("old", this.old);
        json.setString("new", this.newString);
    }

    public @Nullable String getOld() {
        return this.old;
    }

    public @Nullable String getNew() {
        return this.newString;
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        if (this.old == null) {
            builder.raw("old", KingdomsLang.NONE);
        } else {
            builder.parse("old", this.old);
        }
        if (this.newString == null) {
            builder.raw("new", KingdomsLang.NONE);
        } else {
            builder.parse("new", this.newString);
        }
    }
}

