/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.ranks;

import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerRank;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.buildings.structures.RankEditor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\t\b\u0014\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/ranks/LogRankExistence;", "Lorg/kingdoms/constants/group/model/logs/misc/LogPlayerOperator;", "<init>", "()V", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "rank", "Lorg/kingdoms/constants/player/Rank;", "(Lorg/kingdoms/constants/player/KingdomPlayer;Lorg/kingdoms/constants/player/Rank;)V", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addEdits", "builder", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "core"})
public abstract class LogRankExistence
extends LogPlayerOperator {
    @Nullable
    private Rank rank;

    protected LogRankExistence() {
    }

    public LogRankExistence(@NotNull KingdomPlayer player, @NotNull Rank rank) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
        super(player.getId());
        this.rank = rank;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter provider = context.getDataProvider();
        SectionableDataGetter rankSection = provider.get("rank").asSection();
        String node = rankSection.get("node").asString();
        this.rank = DataHandlerRank.deserializeRank(node, rankSection);
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter section = context.getDataProvider().createSection("rank");
        DataHandlerRank.serializeRank(this.rank, section);
        Rank rank = this.rank;
        Intrinsics.checkNotNull((Object)rank);
        section.setString("node", rank.getNode());
    }

    @Override
    public void addEdits(@NotNull MessagePlaceholderProvider builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.inheritPlaceholders(RankEditor.getRankEdits(this.rank));
    }
}

