/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.ranks;

import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public abstract class LogRankChange
extends LogPlayerOperator {
    private String node;
    private String rank;

    protected LogRankChange() {
    }

    public LogRankChange(KingdomPlayer player, Rank rank) {
        super(player.getId());
        this.node = rank.getNode();
        this.rank = rank.getColor() + rank.getSymbol() + ' ' + rank.getName();
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.rank = json.get("rank").asString();
        this.node = json.get("node").asString();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setString("rank", this.rank);
        json.setString("node", this.node);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.raw("node", this.node);
        builder.parse("rank", this.rank);
    }
}

