/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.challenge;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenger;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\t\b\u0014\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\nJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/challenge/LogKingdomChallenge;", "Lorg/kingdoms/constants/group/model/logs/misc/LogPlayerOperator;", "<init>", "()V", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "challenger", "Lorg/kingdoms/constants/player/KingdomPlayer;", "startTime", "", "(Lorg/kingdoms/constants/group/Kingdom;Lorg/kingdoms/constants/player/KingdomPlayer;J)V", "Ljava/util/UUID;", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addEdits", "builder", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "core"})
public abstract class LogKingdomChallenge
extends LogPlayerOperator {
    private UUID kingdom;
    private long startTime;

    protected LogKingdomChallenge() {
    }

    public LogKingdomChallenge(@NotNull Kingdom kingdom, @NotNull KingdomPlayer challenger, long startTime) {
        Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
        Intrinsics.checkNotNullParameter((Object)challenger, (String)"challenger");
        super(challenger.getId());
        this.kingdom = kingdom.getKey();
        this.startTime = startTime;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        UUID uUID = json.get("kingdom").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        this.kingdom = uUID;
        this.startTime = json.get("startTime").asLong();
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        UUID uUID = this.kingdom;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
            uUID = null;
        }
        json.setUUID("kingdom", uUID);
        json.setLong("startTime", this.startTime);
    }

    @Override
    public void addEdits(@NotNull MessagePlaceholderProvider builder) {
        MessagePlaceholderProvider messagePlaceholderProvider;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.raw("start_time", TimeUtils.getDateAndTime(this.startTime));
        OfflinePlayer offlinePlayer = this.getPlayer().getOfflinePlayer();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
        OfflinePlayer player = offlinePlayer;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer(player);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (this instanceof LogKingdomChallenger) {
            UUID uUID = this.kingdom;
            if (uUID == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                uUID = null;
            }
            Kingdom kingdom = Kingdom.getKingdom(uUID);
            messagePlaceholderProvider = builder.withContext(player).other(kingdom);
        } else {
            UUID uUID = kp.getKingdomId();
            UUID uUID2 = this.kingdom;
            if (uUID2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                uUID2 = null;
            }
            if (!Intrinsics.areEqual((Object)uUID, (Object)uUID2)) {
                UUID uUID3 = this.kingdom;
                if (uUID3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                    uUID3 = null;
                }
                Kingdom kingdom = Kingdom.getKingdom(uUID3);
                messagePlaceholderProvider = builder.withContext(kingdom).raw("player", player.getName());
            } else {
                messagePlaceholderProvider = builder.withContext(player);
            }
        }
    }
}

