/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.internal.uuid.FastUUID;

public class LogKingdomResourcePointsConvert
extends AuditLog {
    private UUID player;
    private double amountBefore;
    private double amountAfter;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_RESOURCE_POINTS_CONVERT");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogKingdomResourcePointsConvert();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogKingdomResourcePointsConvert() {
    }

    public LogKingdomResourcePointsConvert(UUID player, double amountBefore, double amountAfter) {
        this.player = player;
        this.amountBefore = amountBefore;
        this.amountAfter = amountAfter;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.player = FastUUID.fromString(json.get("player").asString());
        this.amountBefore = json.get("amountBefore").asDouble();
        this.amountAfter = json.get("amountAfter").asDouble();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("player", this.player);
        json.setDouble("amountBefore", this.amountBefore);
        json.setDouble("amountAfter", this.amountAfter);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.withContext(this.getPlayer());
        builder.raw("amount-before", this.amountBefore);
        builder.raw("amount-after", this.amountAfter);
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.player);
    }
}

