/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.lands.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.comparisons.ComparisonsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.inventory.InventoryItemAction;
import org.kingdoms.utils.nms.JsonItemStack;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\t\b\u0014\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/constants/group/model/logs/lands/inventory/LogInventoryChange;", "Lorg/kingdoms/constants/group/model/logs/misc/LogPlayerOperator;", "<init>", "()V", "player", "Ljava/util/UUID;", "changes", "", "Lorg/kingdoms/managers/inventory/InventoryItemAction;", "(Ljava/util/UUID;Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "setChanges", "(Ljava/util/List;)V", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addEdits", "builder", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "core"})
@SourceDebugExtension(value={"SMAP\nLogInventoryChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogInventoryChange.kt\norg/kingdoms/constants/group/model/logs/lands/inventory/LogInventoryChange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1010#2,2:77\n*S KotlinDebug\n*F\n+ 1 LogInventoryChange.kt\norg/kingdoms/constants/group/model/logs/lands/inventory/LogInventoryChange\n*L\n23#1:77,2\n*E\n"})
public abstract class LogInventoryChange
extends LogPlayerOperator {
    @NotNull
    private List<InventoryItemAction> changes;

    protected LogInventoryChange() {
        this.changes = new ArrayList();
    }

    public LogInventoryChange(@NotNull UUID player, @NotNull List<InventoryItemAction> changes) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        super(player);
        List<InventoryItemAction> $this$sortBy$iv = this.changes = changes;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    InventoryItemAction it = (InventoryItemAction)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getTypeName());
                    it = (InventoryItemAction)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTypeName())));
                }
            });
        }
    }

    @NotNull
    public final List<InventoryItemAction> getChanges() {
        return this.changes;
    }

    public final void setChanges(@NotNull List<InventoryItemAction> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.changes = list;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        context.getDataProvider().get("changes").asCollection((Collection)this.changes, LogInventoryChange::deserialize$lambda$1);
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        context.getDataProvider().get("changes").setCollection((Collection)this.changes, LogInventoryChange::serialize$lambda$2);
    }

    @Override
    public void addEdits(@NotNull MessagePlaceholderProvider builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        MessageObjectLinker linker = new MessageObjectLinker();
        int size = this.changes.size();
        for (InventoryItemAction change : this.changes) {
            InventoryItemAction inventoryItemAction = change;
            KingdomsLang useFormat = inventoryItemAction instanceof InventoryItemAction.Put ? KingdomsLang.INVENTORY_LOG_PUT : (inventoryItemAction instanceof InventoryItemAction.Take ? KingdomsLang.INVENTORY_LOG_TAKE : (inventoryItemAction instanceof InventoryItemAction.Move ? KingdomsLang.INVENTORY_LOG_MOVE : (inventoryItemAction instanceof InventoryItemAction.Swap ? KingdomsLang.INVENTORY_LOG_SWAP : KingdomsLang.UNKNOWN)));
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider();
            change.addMessageContextEdits(settings);
            linker.add(useFormat, settings);
            if (--size <= 0) continue;
            linker.add("\n");
        }
        builder.raw("changes", linker);
    }

    private static final ItemStack deserialize$lambda$1$getItem(SectionableDataGetter section, String name) {
        ItemStack itemStack = JsonItemStack.deserialize(section.getString(name));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserialize(...)");
        return itemStack;
    }

    private static final int deserialize$lambda$1$slot(SectionableDataGetter section, String name) {
        return section.getInt(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void deserialize$lambda$1(List changeProvider, SectionableDataGetter x) {
        InventoryItemAction inventoryItemAction;
        block10: {
            String type;
            SectionableDataGetter section;
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)changeProvider, (String)"changeProvider");
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    section = x.asSection();
                    type = section.getString("type");
                    if (type == null) throw new AssertionError((Object)("Unknown inventory move log: " + type));
                    switch (type.hashCode()) {
                        case 2567303: {
                            if (type.equals("TAKE")) break;
                            throw new AssertionError((Object)("Unknown inventory move log: " + type));
                        }
                        case 2558355: {
                            if (!type.equals("SWAP")) {
                                throw new AssertionError((Object)("Unknown inventory move log: " + type));
                            }
                            break block8;
                        }
                        case 2372561: {
                            if (!type.equals("MOVE")) {
                                throw new AssertionError((Object)("Unknown inventory move log: " + type));
                            }
                            break block9;
                        }
                        case 79599: {
                            if (!type.equals("PUT")) throw new AssertionError((Object)("Unknown inventory move log: " + type));
                            inventoryItemAction = new InventoryItemAction.Put(section.getInt("initialAmount"), LogInventoryChange.deserialize$lambda$1$getItem(section, "item"), LogInventoryChange.deserialize$lambda$1$slot(section, "slot"));
                            break block10;
                        }
                    }
                    inventoryItemAction = new InventoryItemAction.Take(section.getInt("initialAmount"), LogInventoryChange.deserialize$lambda$1$getItem(section, "item"), LogInventoryChange.deserialize$lambda$1$slot(section, "slot"));
                    break block10;
                }
                inventoryItemAction = new InventoryItemAction.Swap(LogInventoryChange.deserialize$lambda$1$slot(section, "slot"), LogInventoryChange.deserialize$lambda$1$getItem(section, "oldItem"), LogInventoryChange.deserialize$lambda$1$getItem(section, "newItem"));
                break block10;
            }
            inventoryItemAction = new InventoryItemAction.Move(LogInventoryChange.deserialize$lambda$1$getItem(section, "item"), LogInventoryChange.deserialize$lambda$1$slot(section, "fromSlot"), LogInventoryChange.deserialize$lambda$1$slot(section, "toSlot"));
            break block10;
            throw new AssertionError((Object)("Unknown inventory move log: " + type));
        }
        InventoryItemAction change = inventoryItemAction;
        changeProvider.add(change);
    }

    private static final void serialize$lambda$2(SectionCreatableDataSetter changeProvider, InventoryItemAction x) {
        Intrinsics.checkNotNullParameter((Object)changeProvider, (String)"changeProvider");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        SectionableDataSetter section = changeProvider.createSection();
        section.setString("type", x.getTypeName());
        x.serialize(section);
    }
}

