/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs;

import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.Deserializable;
import org.kingdoms.data.Serializable;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.utils.time.TimeUtils;

public abstract class AuditLog
implements CascadingMessageContextProvider,
Serializable,
Deserializable {
    private long time = System.currentTimeMillis();

    public abstract @NonNull AuditLogProvider getProvider();

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(@NonNull DeserializationContext<SectionableDataGetter> context) {
        this.time = context.getDataProvider().get("time").asLong();
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(@NonNull SerializationContext<SectionableDataSetter> context) {
        context.getDataProvider().setLong("time", this.time);
    }

    public final long getTime() {
        return this.time;
    }

    @Override
    @MustBeInvokedByOverriders
    public void addMessageContextEdits(@NonNull MessagePlaceholderProvider context) {
        this.addEdits(context);
    }

    @MustBeInvokedByOverriders
    public void addEdits(@NonNull MessagePlaceholderProvider builder) {
        StringBuilder zonedTime = TimeUtils.getDateAndTime(this.time);
        builder.raw("time", zonedTime.toString());
    }
}

