/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.flag;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.flag.GroupBannerProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.ContextualMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.string.Strings;

public final class URLGroupBanner
implements GroupBanner {
    private static final Namespace NAMESPACE = Namespace.kingdoms("URL");
    public static final GroupBannerProvider<URLGroupBanner> PROVIDER = new Provider();
    private URL url;
    private BufferedImage imageCache;
    private Dimension dimension;

    public void setUrl(URL url) {
        this.imageCache = null;
        this.url = url;
    }

    @Override
    public GroupBanner.PreferredMethod getPreferredMethod() {
        return GroupBanner.PreferredMethod.URL;
    }

    @Override
    public Messenger description() {
        String removedProtocol = this.url.toString().replace("https://", "").replace("http://", "");
        if (removedProtocol.length() > 50) {
            removedProtocol = removedProtocol.substring(0, 20) + "..." + removedProtocol.substring(removedProtocol.length() - 20);
        }
        return new ContextualMessenger(KingdomsLang.GROUP_BANNER_URL_DESCRIPTION, new MessagePlaceholderProvider().raw("url", removedProtocol));
    }

    @Override
    public BufferedImage asImage() {
        if (this.imageCache == null) {
            try {
                this.imageCache = ImageIO.read(this.url);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load group banner image", e);
            }
        }
        return this.imageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Dimension getImageSize() {
        if (this.dimension != null) {
            return this.dimension;
        }
        if (this.imageCache != null) {
            this.dimension = new Dimension(this.imageCache.getWidth(), this.imageCache.getHeight());
            return this.dimension;
        }
        try (InputStream stream = this.url.openStream();
             ImageInputStream in = ImageIO.createImageInputStream(stream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = this.dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URL urlOrCreate(Path path) {
        return this.url;
    }

    public GroupBannerProvider<URLGroupBanner> getProvider() {
        return PROVIDER;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        try {
            this.url = new URL(context.getDataProvider().getString("url"));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to parse URL of banner", e);
        }
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.raw("url", this.url);
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        GroupBanner.super.serialize(context);
        context.getDataProvider().setString("url", this.url.toString());
    }

    protected static final class Provider
    implements GroupBannerProvider<URLGroupBanner> {
        private Provider() {
        }

        @Override
        public URLGroupBanner construct() {
            return new URLGroupBanner();
        }

        @Override
        public CompletableFuture<URLGroupBanner> prompt(Player player) {
            KingdomsLang.GROUP_BANNER_URL_PROMPT.sendMessage((CommandSender)player);
            return ChatInputManager.awaitInput(player, input -> {
                URL url = Strings.validateURL(input);
                if (url == null) {
                    KingdomsLang.NEXUS_SETTINGS_FLAG_WRONG_URL.sendMessage((CommandSender)player, "flag", input);
                    return null;
                }
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                if (!kp.isAdmin()) {
                    boolean blacklist = KingdomsConfig.FLAG_LINKS_BLACKLIST.getManager().getBoolean();
                    List<String> contains = KingdomsConfig.FLAG_LINKS_CONTAINS.getManager().getStringList();
                    for (String contain : contains) {
                        boolean matches = input.contains(contain);
                        if (blacklist != matches) continue;
                        KingdomsLang.NEXUS_SETTINGS_FLAG_CONTAINS.sendMessage((CommandSender)player, "flag", input);
                        return null;
                    }
                    List<String> regexs = KingdomsConfig.FLAG_LINKS_REGEX.getManager().getStringList();
                    for (String regex : regexs) {
                        boolean matches = Pattern.compile(regex).matcher((CharSequence)input).find();
                        if (blacklist != matches) continue;
                        KingdomsLang.NEXUS_SETTINGS_FLAG_REGEX.sendMessage((CommandSender)player, "flag", input);
                        return null;
                    }
                }
                KingdomsLang.NEXUS_SETTINGS_FLAG_VALIDATE.sendMessage((CommandSender)player);
                int height = KingdomsConfig.FLAG_SIZE_LIMIT_HEIGHT.getManager().getInt();
                int width = KingdomsConfig.FLAG_SIZE_LIMIT_WIDTH.getManager().getInt();
                if (height > 0 || width > 0) {
                    Dimension dim = Strings.getImageSize(url);
                    if (dim == null) {
                        KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_FAIL.sendMessage((CommandSender)player, "flag", input);
                        return null;
                    }
                    if (!kp.isAdmin()) {
                        if (dim.getHeight() > (double)height) {
                            KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_HEIGHT.sendMessage((CommandSender)player, "flag", input, "limit", height, "height", dim.getHeight());
                            return null;
                        }
                        if (dim.getWidth() > (double)width) {
                            KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_HEIGHT.sendMessage((CommandSender)player, "flag", input, "limit", width, "height", dim.getWidth());
                            return null;
                        }
                    }
                }
                URLGroupBanner banner = this.construct();
                banner.setUrl(url);
                return banner;
            });
        }

        @Override
        public @NonNull Namespace getNamespace() {
            return NAMESPACE;
        }
    }
}

