/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.economy;

import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.constants.economy.Economy;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H&J\b\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\t\u0010\u001e\u001a\u00020\u0005H\u0096\u0002J\t\u0010\u001f\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010!\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010#\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010$\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006%\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/constants/economy/Balance;", "", "", "Lorg/kingdoms/constants/DataStringRepresentation;", "get", "", "set", "value", "getEconomy", "Lorg/kingdoms/constants/economy/Economy;", "transfer", "", "amount", "to", "has", "", "isEmpty", "add", "subtract", "compareTo", "", "other", "asDataString", "", "plus", "amt", "minus", "times", "div", "rem", "unaryPlus", "unaryMinus", "plusAssign", "minusAssign", "timesAssign", "divAssign", "remAssign", "shared"})
public interface Balance
extends Comparable<Number>,
DataStringRepresentation {
    public double get();

    public double set(@NotNull Number var1);

    @NotNull
    public Economy getEconomy();

    default public void transfer(@NotNull Number amount, @NotNull Balance to) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.subtract(amount);
        to.add(amount);
    }

    default public boolean has(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.get() >= amount.doubleValue();
    }

    default public boolean isEmpty() {
        return !this.has(1);
    }

    default public double add(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.set(this.get() + amount.doubleValue());
    }

    default public double subtract(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.set(this.get() - amount.doubleValue());
    }

    @Override
    default public int compareTo(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Double.compare(this.get(), other.doubleValue());
    }

    @Override
    @NotNull
    default public String asDataString() {
        return String.valueOf(this.get());
    }

    default public /* synthetic */ double plus(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        return this.get() + amt.doubleValue();
    }

    default public /* synthetic */ double minus(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        return this.get() - amt.doubleValue();
    }

    default public /* synthetic */ double times(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        return this.get() * amt.doubleValue();
    }

    default public /* synthetic */ double div(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        return this.get() / amt.doubleValue();
    }

    default public /* synthetic */ double rem(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        return this.get() % amt.doubleValue();
    }

    default public /* synthetic */ double unaryPlus() {
        return this.get();
    }

    default public /* synthetic */ double unaryMinus() {
        return -this.get();
    }

    default public /* synthetic */ void plusAssign(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.add(amt);
    }

    default public /* synthetic */ void minusAssign(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.subtract(amt);
    }

    default public /* synthetic */ void timesAssign(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.set(this.get() * amt.doubleValue());
    }

    default public /* synthetic */ void divAssign(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.set(this.get() / amt.doubleValue());
    }

    default public /* synthetic */ void remAssign(Number amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.set(this.get() % amt.doubleValue());
    }
}

