/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.base;

import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.base.CompressedSmartObject;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.Loggable;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.CascadingMessageContextProvider;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public abstract class KingdomsObject
extends CompressedSmartObject
implements Loggable,
CascadingMessageContextProvider {
    protected @NonNull Map<KingdomMetadataHandler, KingdomMetadata> metadata;
    protected transient long lastLogsExpirationCheck;
    protected @NonNull LinkedList<AuditLog> logs;
    protected Statistics statistics;

    protected KingdomsObject() {
        this(new NonNullMap<KingdomMetadataHandler, KingdomMetadata>(), new LinkedList<AuditLog>(), new Statistics());
    }

    protected KingdomsObject(@NonNull Map<KingdomMetadataHandler, KingdomMetadata> metadata, @NonNull LinkedList<AuditLog> logs, @NonNull Statistics statistics) {
        this.logs = Objects.requireNonNull(logs, "Logs cannot be null");
        this.statistics = Objects.requireNonNull(statistics, "Stats cannot be null");
        this.setMetadata(metadata);
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
    }

    public <C extends AuditLog> C getNewestLog(Class<C> base) {
        return (C)this.getNewestLog(base, x -> x);
    }

    public <C extends AuditLog, T> T getNewestLog(Class<C> base, Function<C, T> transformer) {
        this.ensureObjectExpiration();
        Iterator<AuditLog> descending = this.getLogs().descendingIterator();
        while (descending.hasNext()) {
            T result;
            AuditLog next = descending.next();
            if (!base.isInstance(next) || (result = transformer.apply(next)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public @NonNull LinkedList<AuditLog> getLogs() {
        this.ensureObjectExpiration();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogsExpirationCheck < Duration.ofHours(1L).toMillis()) {
            return this.logs;
        }
        long defaultExpiration = KingdomsConfig.AUDIT_LOGS_EXPIRATION_DEFAULT.getTimeMillis();
        YamlConfigAccessor specifics = KingdomsConfig.AUDIT_LOGS_EXPIRATION.getManager().getSection().noDefault();
        Iterator iter = this.logs.iterator();
        while (iter.hasNext()) {
            long time;
            long diff;
            AuditLog log = (AuditLog)iter.next();
            Long expirationTime = specifics.get(log.getProvider().getNamespace().getConfigOptionName()).getTimeMillis();
            if (expirationTime == null) {
                expirationTime = defaultExpiration;
            }
            if ((diff = currentTime - (time = log.getTime())) < expirationTime) continue;
            iter.remove();
        }
        this.lastLogsExpirationCheck = currentTime;
        return this.logs;
    }

    @ApiStatus.Internal
    public void setLogs(@NonNull LinkedList<AuditLog> logs) {
        this.logs = Objects.requireNonNull(logs);
    }

    @Override
    public void log(AuditLog log) {
        this.ensureObjectExpiration();
        if (KingdomsConfig.AUDIT_LOGS_DISABLED.getStringList().contains(log.getProvider().getNamespace().getConfigOptionName())) {
            return;
        }
        this.logs.add(log);
    }

    public void setMetadata(Map<KingdomMetadataHandler, KingdomMetadata> metadata) {
        this.metadata = NonNullMap.of(Objects.requireNonNull(metadata, "Metadata cannot be null"));
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public @NonNull Map<KingdomMetadataHandler, KingdomMetadata> getMetadata() {
        this.ensureObjectExpiration();
        return this.metadata;
    }
}

