/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.implementation;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigPathBuilder;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpretContext;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.internal.string.StringMatcher;

public class KeyedYamlConfigAccessor
implements KeyedConfigAccessor,
EnumConfig,
Cloneable {
    private final ConfigSection config;
    private final ConfigSection defaults;
    private final ConfigPathBuilder path;
    private boolean noDefault;

    private KeyedYamlConfigAccessor(@NotNull ConfigSection config, @Nullable ConfigSection defaults, @NotNull ConfigPathBuilder path, boolean noDefault) {
        this.config = config;
        this.defaults = defaults;
        this.path = path;
        this.noDefault = noDefault;
    }

    public KeyedYamlConfigAccessor(@NotNull ConfigSection config, @Nullable ConfigSection defaults, @NotNull ConfigPath option) {
        this.path = new ConfigPathBuilder(Objects.requireNonNull(option, "option for keyed config accessor cannot be null"));
        this.config = config;
        this.defaults = defaults;
    }

    public KeyedYamlConfigAccessor(@NotNull YamlContainer adapter, @NotNull ConfigPath option) {
        this(Objects.requireNonNull(adapter, "Adapter is null").getConfig(), !(adapter instanceof YamlWithDefaults) ? null : ((YamlWithDefaults)adapter).getDefaults(), option);
    }

    public boolean isInDisabledWorld(Entity entity2) {
        String world = entity2.getWorld().getName();
        return StringMatcher.parseAndGroup(this.getStringList()).matches(world);
    }

    @Override
    public KeyedYamlConfigAccessor withProperty(String prop) {
        this.path.withProperty(prop);
        return this;
    }

    @Override
    public KeyedYamlConfigAccessor clearExtras() {
        this.path.clearExtras();
        return this;
    }

    @Override
    public String getOptionPath() {
        return this.path.getOptionPath();
    }

    @Override
    public KeyedYamlConfigAccessor noDefault() {
        this.noDefault = true;
        return this;
    }

    @Override
    public KeyedYamlConfigAccessor withOption(String first, String second) {
        this.path.replace(first, second);
        return this;
    }

    @Override
    public KeyedConfigAccessor applyProperties() {
        return new KeyedYamlConfigAccessor(this.config, this.defaults, new ConfigPath(this.path.build()));
    }

    @Override
    public Node getNode() {
        String[] path = this.path.build();
        Node node = this.config.findNode(path);
        if (node != null) {
            return node;
        }
        if (this.noDefault || this.defaults == null) {
            return null;
        }
        return this.defaults.findNode(path);
    }

    @Override
    public boolean isSet() {
        return this.getNode() != null;
    }

    @Override
    public String getString() {
        return NodeInterpreter.STRING.parse(this.getNode());
    }

    @Override
    public MathExpression getMathExpression() {
        return NodeInterpreter.MATH.parse(this.getNode());
    }

    @Override
    public <T> T get(NodeInterpreter<T> nodeInterpreter) {
        return nodeInterpreter.parse(this.getNode());
    }

    @Override
    public <T> T get(NodeInterpreter<T> interpreter, NodeInterpretContext<T> ctx) {
        return interpreter.parse(ctx.withNode(this.getNode()));
    }

    public ConditionalExpression getCondition() {
        return NodeInterpreter.CONDITION.parse(this.getNode());
    }

    @Override
    public List<String> getStringList() {
        return NodeInterpreter.STRING_LIST.parse(this.getNode());
    }

    @Override
    public Set<String> getSectionKeys() {
        YamlConfigAccessor section = this.getSection();
        return section == null ? new HashSet() : section.getKeys();
    }

    @Override
    public boolean getBoolean() {
        return NodeInterpreter.BOOLEAN.parse(this.getNode());
    }

    @Override
    public List<Integer> getIntegerList() {
        return this.get(NodeInterpreter.INT_LIST);
    }

    @Override
    public int getInt() {
        return this.get(NodeInterpreter.INT);
    }

    @Override
    public double getDouble() {
        return NodeInterpreter.DOUBLE.parse(this.getNode());
    }

    @Override
    public long getLong() {
        return NodeInterpreter.LONG.parse(this.getNode());
    }

    @Override
    public YamlConfigAccessor getSection() {
        ConfigSection defaultsSection;
        ConfigSection val = this.config.getSection(this.path.build());
        ConfigSection configSection = defaultsSection = this.defaults == null ? null : this.defaults.getSection(this.path.build());
        if (val != null) {
            return new YamlConfigAccessor(val, this.noDefault || defaultsSection == null ? val : defaultsSection);
        }
        if (this.noDefault || defaultsSection == null) {
            return null;
        }
        YamlConfigAccessor accessor = new YamlConfigAccessor(defaultsSection, defaultsSection);
        if (this.noDefault) {
            accessor.noDefault();
        }
        return accessor;
    }

    protected KeyedYamlConfigAccessor clone() throws CloneNotSupportedException {
        return new KeyedYamlConfigAccessor(this.config, this.defaults, this.path.clone(), this.noDefault);
    }

    public String toString() {
        return "KeyedYamlConfigAccessor( " + this.getOptionPath();
    }

    @Override
    public KeyedConfigAccessor getManager() {
        return this;
    }
}

