/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.spawn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LocationLocale;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;

public class CommandNationSetSpawn
extends KingdomsCommand {
    public CommandNationSetSpawn(KingdomsParentCommand parent) {
        super("setspawn", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Location home;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, KingdomsLang.DISABLED_WORLD)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        if (!kp.hasNationPermission(StandardKingdomPermission.SET_HOME)) {
            StandardKingdomPermission.SET_HOME.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                KingdomsLang.COMMAND_NATION_SETSPAWN_NOT_CLAIMED.sendMessage(sender);
                return CommandResult.FAILED;
            }
        } else {
            Kingdom owner = land.getKingdom();
            if (!kingdom.isInSameNationAs(owner)) {
                KingdomsLang.COMMAND_NATION_SETSPAWN_OTHERS_LAND.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (KingdomsConfig.HOME_NATION_SPAWN_CAPITAL.getBoolean() && !nation.getCapitalId().equals(owner.getId())) {
                KingdomsLang.COMMAND_NATION_SETSPAWN_OTHERS_LAND.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (KingdomsConfig.HOME_NEXUS_LAND.getBoolean() && !land.isNexusLand()) {
                KingdomsLang.COMMAND_NATION_SETSPAWN_NEXUS_LAND.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
        }
        if (nation.setHome(BukkitAdapter.adapt(home = CommandSetHome.readjustHomeLocation(context, player.getLocation())), kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        LocationLocale.of(home).withBuilder(context.getMessageContext()).build();
        for (Player member : nation.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, KingdomsLang.COMMAND_NATION_SETSPAWN_SET, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context instanceof Player && context.isAtArg(0) ? Arrays.asList("center", "centerAxis", "centerView") : new ArrayList<String>();
    }
}

