/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.ranking;

import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationPromote
extends KingdomsCommand {
    public CommandNationPromote(KingdomsParentCommand parent) {
        super("promote", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasNation()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer promoterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = promoterKp.getKingdom();
        Nation nation = kingdom.getNation();
        if (!promoterKp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        OfflinePlayer promoting = context.getOfflinePlayer(0);
        if (promoting == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer promotingKp = KingdomPlayer.getKingdomPlayer(promoting);
        Kingdom promotingKingdom = promotingKp.getKingdom();
        if (!kingdom.isInSameNationAs(promotingKingdom)) {
            KingdomsLang.COMMAND_NATION_PROMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "promoted", promoting.getName());
            return CommandResult.FAILED;
        }
        Rank rank = promotingKp.getNationRank();
        if (!promoterKp.getNationRank().isHigherThan(rank)) {
            KingdomsLang.COMMAND_NATION_PROMOTE_CANT_PROMOTE.sendError((CommandSender)player, "promoted", promoting.getName());
            return CommandResult.FAILED;
        }
        if (rank.isKing()) {
            KingdomsLang.COMMAND_NATION_PROMOTE_KING.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!rank.canBePromoted()) {
            KingdomsLang.COMMAND_NATION_PROMOTE_TO_BE_KING.sendError((CommandSender)player, "promoted", promoting.getName(), "rank", rank.getColor() + rank.getName());
            return CommandResult.FAILED;
        }
        PlayerRankChangeEvent newRankEvent = promotingKp.changeRank(new PlayerRankChangeContext(nation, RankIdentifier.promote()).byPlayer(promoterKp));
        if (newRankEvent.isCancelled()) {
            return CommandResult.FAILED;
        }
        rank = newRankEvent.getRank();
        context.getMessageContext().withContext(player).parse("rank", rank.getColor() + rank.getName()).parse("promoted", promoting.getName());
        for (Player member : nation.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, KingdomsLang.COMMAND_NATION_PROMOTE_PROMOTED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0) && context.isPlayer()) {
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (!kp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                return Collections.singletonList(StandardKingdomPermission.MANAGE_RANKS.getDeniedMessage().parse(player, new Object[0]));
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return Collections.singletonList(KingdomsLang.NO_NATION.parse(player, new Object[0]));
            }
            return TabCompleteManager.getKingdomPlayers(nation, context.arg(0), p -> true);
        }
        return CommandNationPromote.emptyTab();
    }
}

