/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.ranking;

import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationDemote
extends KingdomsCommand {
    public CommandNationDemote(KingdomsParentCommand parent) {
        super("demote", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasNation()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer demoterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = demoterKp.getKingdom();
        Nation nation = kingdom.getNation();
        if (!demoterKp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        if (args.length < 1) {
            KingdomsLang.COMMAND_NATION_DEMOTE_USAGE.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        OfflinePlayer demoting = context.getOfflinePlayer(0);
        if (demoting == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer demotingKp = KingdomPlayer.getKingdomPlayer(demoting);
        Kingdom demotingKingdom = demotingKp.getKingdom();
        if (!kingdom.isInSameNationAs(demotingKingdom)) {
            KingdomsLang.COMMAND_NATION_DEMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "demoted", demoting.getName());
            return CommandResult.FAILED;
        }
        Rank rank = demotingKp.getNationRank();
        if (!demoterKp.getRank().isHigherThan(rank)) {
            KingdomsLang.COMMAND_NATION_DEMOTE_CANT_DEMOTE.sendError((CommandSender)player, "demoted", demoting.getName());
            return CommandResult.FAILED;
        }
        if (nation.getRanks().isMemberRank(rank)) {
            KingdomsLang.COMMAND_NATION_DEMOTE_MEMBER.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        @NonNull PlayerRankChangeEvent event = demotingKp.changeRank(new PlayerRankChangeContext(nation, RankIdentifier.demote()).byPlayer(demoterKp));
        if (event.isCancelled()) {
            return CommandResult.FAILED;
        }
        rank = event.getRank();
        Object[] edits = new Object[]{"rank", rank.getColor() + rank.getName(), "demoted", demoting.getName()};
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_DEMOTE_DEMOTED.sendMessage((CommandSender)member, (OfflinePlayer)player, edits);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0) && context.isPlayer()) {
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (!kp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                return Collections.singletonList(StandardKingdomPermission.MANAGE_RANKS.getDeniedMessage().parse(player, new Object[0]));
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return Collections.singletonList(KingdomsLang.NO_NATION.parse(player, new Object[0]));
            }
            return TabCompleteManager.getKingdomPlayers(nation, context.arg(0), p -> true);
        }
        return CommandNationDemote.emptyTab();
    }
}

