/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.ranking;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationCapital
extends KingdomsCommand {
    public CommandNationCapital(KingdomsParentCommand parent) {
        super("capital", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        Nation nation = kingdom.getNation();
        if (nation == null) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        context.getMessageContext().other(kingdom);
        if (!kp.getNationRank().isKing()) {
            KingdomsLang.COMMAND_NATION_CAPITAL_ONLY_KING.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom capital = context.getKingdom(0);
        if (capital == null) {
            return CommandResult.FAILED;
        }
        if (!capital.getNationId().equals(nation.getId())) {
            KingdomsLang.COMMAND_NATION_CAPITAL_NOT_IN_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (capital.getId().equals(nation.getCapitalId())) {
            context.fail(KingdomsLang.COMMAND_NATION_CAPITAL_ALREADY);
            return CommandResult.FAILED;
        }
        nation.setCapital(capital);
        if (KingdomsConfig.ANNOUNCEMENTS_KING.getBoolean()) {
            for (Player member : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_NATION_CAPITAL_SET.sendMessage((CommandSender)member, "old_capital", kingdom.getName());
            }
        } else {
            for (Player member : nation.getOnlineMembers()) {
                KingdomsLang.COMMAND_NATION_CAPITAL_SET.sendMessage((CommandSender)member, "old_capital", kingdom.getName());
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.getKingdoms(0);
    }
}

