/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.invitations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.time.TimeUtils;

public class CommandNationInvite
extends KingdomsCommand
implements Listener {
    public CommandNationInvite(KingdomsParentCommand parent) {
        super("invite", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        KingdomInvite invite;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasNation()) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        final Player inviter = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)inviter);
        final Kingdom kingdom = kp.getKingdom();
        if (!kp.hasNationPermission(StandardKingdomPermission.INVITE)) {
            context.fail(KingdomsLang.PERMISSIONS_NATION_INVITE);
            return CommandResult.FAILED;
        }
        final Kingdom invited = context.getKingdom(0);
        if (invited == null) {
            return CommandResult.FAILED;
        }
        if (invited.getId().equals(kingdom.getId())) {
            KingdomsLang.COMMAND_NATION_INVITE_SELF.sendMessage((CommandSender)inviter);
            return CommandResult.FAILED;
        }
        if (invited.hasNation()) {
            if (invited.isInSameNationAs(kingdom)) {
                KingdomsLang.COMMAND_NATION_INVITE_ALREADY_JOINED.sendMessage((CommandSender)inviter, "kingdom", invited.getName());
                return CommandResult.FAILED;
            }
            if (!KingdomsConfig.INVITATIONS_ALLOW_FROM_OTHER_KINGDOMS.getBoolean()) {
                KingdomsLang.COMMAND_NATION_INVITE_ALREADY_IN_KINGDOM.sendMessage((CommandSender)inviter, "kingdom", invited.getName());
                return CommandResult.FAILED;
            }
        }
        if ((invite = invited.getNationInvites().get(kingdom.getNationId())) != null) {
            KingdomsLang.COMMAND_NATION_INVITE_ALREADY_NATION_INVITED.sendMessage((CommandSender)inviter, "inviter", invite.getKingdomPlayer().getOfflinePlayer().getName());
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        if (nation.getMembers().size() >= nation.getMaxMembers()) {
            KingdomsLang.COMMAND_NATION_INVITE_MAX_MEMBERS.sendMessage((CommandSender)inviter);
            return CommandResult.FAILED;
        }
        Long time = null;
        if (args.length > 1) {
            time = TimeUtils.parseTime(args[1]);
        }
        if (time == null) {
            time = TimeUtils.parseTime(KingdomsConfig.INVITATIONS_EXPIRATION_DEFAULT_EXPIRE.getString());
        }
        KingdomInvite invitation = new KingdomInvite(kp.getId(), time);
        invited.getNationInvites().put(kingdom.getNationId(), invitation);
        final Object[] edits = new Object[]{"inviter", inviter.getName(), "kingdom", invited.getName(), "invited", invited.getName(), "nation", nation.getName()};
        if (time < TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS)) {
            new BukkitRunnable(){

                public void run() {
                    if (invited.getNationInvites().remove(kingdom.getNationId()) != null) {
                        for (Player member : invited.getOnlineMembers()) {
                            KingdomsLang.COMMAND_NATION_INVITE_EXPIRED.sendMessage((CommandSender)member, edits);
                        }
                        if (inviter.isOnline()) {
                            KingdomsLang.COMMAND_NATION_INVITE_EXPIRED_NOTIFY.sendMessage((CommandSender)inviter, edits);
                        }
                    }
                }
            }.runTaskLaterAsynchronously((Plugin)Kingdoms.get(), TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) * 20L);
        }
        if (KingdomsConfig.INVITATIONS_ANNOUNCE.getBoolean()) {
            for (Player member : nation.getOnlineMembers()) {
                KingdomsLang.COMMAND_NATION_INVITE_ANNOUNCE.sendMessage((CommandSender)member, edits);
            }
        }
        for (Player member : invited.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_INVITE_INVITED.sendMessage((CommandSender)member, edits);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context instanceof Player) {
            if (context.isAtArg(0)) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)context));
                Kingdom kingdom = kp.getKingdom();
                if (kingdom == null) {
                    return new ArrayList<String>();
                }
                return context.getKingdoms(0, x -> !x.equals(kingdom.getName()));
            }
            if (context.isAtArg(1)) {
                return Collections.singletonList("[expiration]");
            }
        }
        return context.emptyTab();
    }
}

