/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationDecline
extends KingdomsCommand {
    public CommandNationDecline(KingdomsParentCommand parent) {
        super("decline", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.NATION)) {
            StandardKingdomPermission.NATION.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        Map<UUID, KingdomInvite> invites = kingdom.getNationInvites();
        if (invites.isEmpty()) {
            KingdomsLang.COMMAND_NATION_ACCEPT_NO_INVITES.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (args.length == 0) {
            if (invites.size() != 1) {
                KingdomsLang.COMMAND_DECLINE_MULTIPLE_INVITES.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            Map.Entry<UUID, KingdomInvite> inviteEntry = invites.entrySet().iterator().next();
            KingdomInvite invite = inviteEntry.getValue();
            Nation nation = Nation.getNation(inviteEntry.getKey());
            invites.clear();
            if (nation == null) {
                KingdomsLang.COMMAND_DECLINE_NO_LONGER_EXISTS.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (!invite.canAccept()) {
                KingdomsLang.COMMAND_DECLINE_EXPIRED.sendMessage((CommandSender)player, "nation", nation.getName());
                return CommandResult.FAILED;
            }
            KingdomPlayer inviter = invite.getKingdomPlayer();
            OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
            KingdomsLang.COMMAND_NATION_DECLINE_DECLINED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "kingdom", kingdom.getName(), "nation", nation.getName());
            if (inviterPlayer.isOnline()) {
                KingdomsLang.COMMAND_DECLINE_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName());
            }
            return CommandResult.FAILED;
        }
        String arg = args[0];
        if (arg.equalsIgnoreCase("*")) {
            invites.clear();
            KingdomsLang.COMMAND_DECLINE_ALL.sendMessage((CommandSender)player, "invites", invites.size());
            return CommandResult.FAILED;
        }
        Nation nation = Nation.getNation(arg);
        if (nation == null) {
            KingdomsLang.COMMAND_DECLINE_NO_LONGER_EXISTS.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        KingdomInvite invite = invites.remove(nation.getId());
        if (invite == null) {
            KingdomsLang.COMMAND_DECLINE_NOT_INVITED.sendMessage((CommandSender)player, "kingdom", kingdom.getName(), "nation", nation.getName());
            return CommandResult.FAILED;
        }
        if (!invite.canAccept()) {
            KingdomsLang.COMMAND_DECLINE_EXPIRED.sendMessage((CommandSender)player, "kingdom", kingdom.getName(), "nation", nation.getName());
            return CommandResult.FAILED;
        }
        KingdomPlayer inviter = invite.getKingdomPlayer();
        OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
        KingdomsLang.COMMAND_NATION_DECLINE_DECLINED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "kingdom", kingdom.getName(), "nation", nation.getName());
        if (inviterPlayer.isOnline()) {
            KingdomsLang.COMMAND_DECLINE_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName());
        }
        return CommandResult.SUCCESS;
    }
}

