/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.elections;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.ElectionsCommand;
import org.kingdoms.commands.nation.elections.CommandNationElection;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.MathUtils;

public class CommandNationElectionRegister
extends KingdomsCommand
implements ElectionsCommand {
    public CommandNationElectionRegister(KingdomsParentCommand command) {
        super("register", command);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Optional<Stat> sinceStat;
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (CommandNationElection.electionCommons(context, this.getElectionsManager())) {
            return CommandResult.FAILED;
        }
        String statement = context.arg(0);
        context.var("candidacy_statement", statement);
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        ElectionCandidate candidate = this.getElectionsManager().getCandidate(kingdom.getId());
        if (candidate != null) {
            return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_ALREADY_REGISTERED);
        }
        ConfigAccessor requirements = this.getElectionsManager().getOption("candidate-requirements").getSection();
        Runnable finalizeFee = null;
        double fee = MathUtils.eval(requirements.get("fee").getMathExpression(), (PlaceholderProvider)context.getMessageContext());
        context.var("candidacy_fee", fee);
        if (fee > 0.0 && SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO)) {
            Balance balance = kingdom.getBank();
            if (!balance.has(fee)) {
                return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_REQUIREMENTS_FEE);
            }
            finalizeFee = () -> {
                balance.subtract(fee);
                kingdom.getNation().getBank().add(fee);
            };
        }
        if ((sinceStat = kingdom.getStatistics().find(DefaultStats.Kingdom.NATION_SINCE)).isPresent()) {
            Duration memberForReq = requirements.get("member-for").getTime(context.getMessageContext());
            Duration memberFor = Duration.ofMillis(System.currentTimeMillis() - sinceStat.get().asNumber());
            context.var("candidacy_member_for", memberForReq == null ? Integer.valueOf(0) : memberForReq);
            if (memberForReq != null && memberForReq.minus(memberFor).isNegative()) {
                return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_REQUIREMENTS_MEMBER_FOR);
            }
        } else {
            context.var("candidacy_member_for", 0);
        }
        context.requireYesNo(KingdomsLang.COMMAND_NATION_ELECTION_REGISTER_REQUIREMENTS_CONFIRM);
        if (finalizeFee != null) {
            finalizeFee.run();
        }
        this.getElectionsManager().registerCandidate(kingdom.getId(), statement);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ELECTION_REGISTER_REGISTERED, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.tabComplete("<statement>");
        }
        return context.emptyTab();
    }

    @Override
    @NotNull
    public ElectionsManager getElectionsManager() {
        return Elections.NATIONS;
    }
}

