/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.ContextualMessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.internal.functional.Fn;

public class CommandNationShow
extends KingdomsCommand {
    private static final int RELATION_LIMIT = 30;

    public CommandNationShow(KingdomsParentCommand parent) {
        super("show", parent);
    }

    private static void show(CommandContext context, OfflinePlayer placeholder, Nation nation, boolean adminView) {
        CommandSender sender = context.getMessageReceiver();
        KingdomPlayer kp = context.getKingdomPlayer();
        Language locale = kp.getLanguage();
        OfflinePlayer king = nation.getCapital().getKing().getOfflinePlayer();
        KingdomsLang kingStatus = king.isOnline() ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
        ContextualMessageObject kingBuilder = new ContextualMessageObject(kingStatus.getMessageObject(locale), new MessagePlaceholderProvider().withContext(king));
        MessageObjectLinker membersBuilder = new MessageObjectLinker();
        int memberLimit = XReflection.supports((int)17) ? 30 : 10;
        int remaining = nation.getMembers().size() - memberLimit;
        for (Kingdom kingdom : nation.getKingdoms()) {
            if (memberLimit-- == 0) {
                membersBuilder.add(KingdomsLang.COMMAND_NATION_SHOW_MEMBERS_ETC, new MessagePlaceholderProvider().withContext(kingdom).raw("remaining", remaining));
                break;
            }
            membersBuilder.add(KingdomsLang.COMMAND_NATION_SHOW_KINGDOMS.getMessageObject(locale), new MessagePlaceholderProvider().withContext(kingdom));
            membersBuilder.add(" ");
        }
        MessageObjectLinker allies = new MessageObjectLinker();
        MessageObjectLinker truces = new MessageObjectLinker();
        MessageObjectLinker enemies = new MessageObjectLinker();
        int ally = 0;
        int truce = 0;
        int enemy = 0;
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (Map.Entry<UUID, KingdomRelation> relation : nation.getRelations().entrySet()) {
            Nation otherNation = Nation.getNation(relation.getKey());
            if (otherNation == null) {
                remove.add(relation.getKey());
                KLogger.error("Unknown kingdom while mapping relations of kingdom " + nation.getName() + ": " + relation.getKey());
                continue;
            }
            KingdomRelation rel = relation.getValue();
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(nation);
            MessageObject msg = KingdomsLang.COMMAND_NATION_SHOW_RELATION.getMessageObject(locale);
            switch (rel) {
                case ALLY: {
                    if (ally == 30) {
                        allies.add("...");
                    } else if (ally < 30) {
                        allies.add(msg, settings).add(" ");
                    }
                    ++ally;
                    break;
                }
                case TRUCE: {
                    if (truce == 30) {
                        truces.add("...");
                    } else if (truce < 30) {
                        truces.add(msg, settings).add(" ");
                    }
                    ++truce;
                    break;
                }
                case ENEMY: {
                    if (enemy == 30) {
                        enemies.add("...");
                    } else if (enemy < 30) {
                        enemies.add(msg, settings).add(" ");
                    }
                    ++enemy;
                }
            }
        }
        for (UUID id : remove) {
            nation.getRelations().remove(id);
        }
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().raws("king_status", kingBuilder, "kingdoms", membersBuilder, "truces", truces, "allies", allies, "enemies", enemies);
        if (placeholder == null) {
            settings.withContext(nation);
        } else if (sender instanceof Player) {
            settings.withContext(placeholder).other((Player)sender);
        } else {
            settings.withContext(placeholder);
        }
        KingdomsLang lang = sender instanceof Player ? (adminView ? KingdomsLang.COMMAND_NATION_SHOW_MESSAGE_ADMIN : KingdomsLang.COMMAND_NATION_SHOW_MESSAGE) : KingdomsLang.COMMAND_NATION_SHOW_MESSAGE_ADMIN;
        lang.sendMessage(sender, settings);
        if (ally != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_ALLIES.sendMessage(sender, new MessagePlaceholderProvider().raws("allies", allies));
        }
        if (truce != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_TRUCES.sendMessage(sender, new MessagePlaceholderProvider().raws("truces", truces));
        }
        if (enemy != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_ENEMIES.sendMessage(sender, new MessagePlaceholderProvider().raws("enemies", enemies));
        }
    }

    @Override
    public CommandResult execute(CommandContext context) {
        OfflinePlayer placeholder;
        Nation nation;
        if (!context.isPlayer() && context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        boolean admin = context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_NATION_SHOW_ADMIN, true);
        if (context.argsLengthEquals(0)) {
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            if (context.assertHasNation()) {
                return CommandResult.FAILED;
            }
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            nation = kp.getKingdom().getNation();
            placeholder = player;
            admin = true;
        } else {
            nation = (Nation)context.generalSelector(true);
            if (nation == null) {
                return CommandResult.FAILED;
            }
            placeholder = nation.getCapital().getKing().getOfflinePlayer();
        }
        if (!admin) {
            admin = nation.isMember((OfflinePlayer)context.senderAsPlayer());
        }
        if (!admin && !context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_NATION_SHOW_OTHERS)) {
            context.sendError(KingdomsLang.COMMAND_NATION_SHOW_OTHERS_PERMISSION, new Object[0]);
            return CommandResult.FAILED;
        }
        CommandNationShow.show(context, placeholder, nation, admin);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(true, true, Fn.alwaysTrue()).build();
    }
}

