/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.commands.nation.CommandNationRename;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.Strings;

public class CommandNationCreate
extends KingdomsCommand {
    private static final Cooldown<Integer> CONFIRMATION_COOLDOWN = new Cooldown();

    public CommandNationCreate(KingdomsParentCommand parent) {
        super("create", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Land land;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.getRank().isKing()) {
            context.fail(KingdomsLang.COMMAND_NATION_CREATE_KING_ONLY);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.hasNation()) {
            KingdomsLang.COMMAND_NATION_CREATE_ALREADY_IN_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        String name = context.arg(0);
        if (context.assertArgs(2)) {
            name = Strings.buildArguments(context.args, KingdomsConfig.NATION_NAME_ALLOW_SPACES.getBoolean() ? " " : "");
        }
        if (!kp.isAdmin()) {
            double cost;
            if (!CommandNationRename.checkName(name, player)) {
                return CommandResult.FAILED;
            }
            if (ServiceHandler.bankServiceAvailable() && (cost = KingdomsConfig.ECONOMY_COSTS_CREATE_NATION.getDouble()) > 0.0) {
                if (!ServiceVault.hasMoney((OfflinePlayer)player, cost)) {
                    KingdomsLang.COMMAND_NATION_CREATE_COST.sendMessage((CommandSender)player, "cost", cost);
                    return CommandResult.FAILED;
                }
                if (!CONFIRMATION_COOLDOWN.add((Integer)player.getEntityId(), KingdomsConfig.ECONOMY_CREATE_CONFIRMATION.getTimeMillis())) {
                    KingdomsLang.COMMAND_CREATE_CONFIRMATION.sendMessage((CommandSender)player, "cost", cost);
                    return CommandResult.FAILED;
                }
                ServiceVault.withdraw((OfflinePlayer)player, cost);
            }
        }
        Nation nation = new Nation(kingdom, name);
        Duration protection = KingdomsConfig.CREATION_NATIONS_NEWBIE_PROTECTION.getTime();
        if (!protection.isZero()) {
            kingdom.getShield().setDuration(protection);
        }
        if (KingdomsConfig.ANNOUNCEMENTS_CREATE_NATION.getBoolean()) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_NATION_CREATE_ANNOUNCE.sendMessage((CommandSender)online, (OfflinePlayer)player, new Object[]{"nation", name});
            }
        } else {
            KingdomsLang.COMMAND_NATION_CREATE_SUCCESS.sendMessage((CommandSender)player, "nation", name);
        }
        XSound.play((String)KingdomsConfig.CREATION_NATIONS_SOUND.getString(), x -> x.forPlayers(new Player[]{player}));
        boolean claimed = kingdom.isClaimed(SimpleChunkLocation.of(player.getLocation()));
        if (KingdomsConfig.HOME_SET_ON_CREATE.getBoolean()) {
            Location newHome = player.getLocation().clone().add(0.0, 1.0, 0.0);
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                if (claimed) {
                    CommandSetHome.setHome(nation, BukkitAdapter.adapt(newHome), kp);
                }
            } else {
                CommandSetHome.setHome(nation, BukkitAdapter.adapt(newHome), kp);
            }
        }
        if (KingdomsConfig.NEXUS_PLACE_ON_CREATE.getBoolean() && claimed && ((land = Land.getLand(player.getLocation())) == null || land.getStructures().isEmpty()) && !LocationUtils.exceedsBuildLimit(player.getLocation())) {
            nation.placeOrMoveNexus(BukkitAdapter.adapt(player.getLocation()), kp);
        }
        CONFIRMATION_COOLDOWN.stop(player.getEntityId());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.tabComplete((Messenger)KingdomsLang.COMMAND_CREATE_TAB_COMPLETION_NAME);
        }
        return new ArrayList<String>();
    }
}

